##############################################################
##                 1장 R 프로그램 설치와 기초실습           ##
##############################################################

## (1) R 명령문 작성 ##
(4+201)*2
x <- 1:10
print(x)


## (2) 산술연산자 실습 ##
a <- 100
b <- 5
r1 <- a+b
r2 <- a-b
r3 <- a*b
r4 <- a/b
r5 <- a%%b  #나머지 계산
r6 <- b^b     #제곱계산

r1; r2; r3; r4; r5  #한 줄에 다양한 명령어 실행


## (3) 관계연산자 실습 ##
a <- 100
b <- 5
c <- 5

r1 <- a==b   #a와 b는 같다.
r2 <- b==c
r3 <- a>b
r4 <- b>c
r5 <- b>=c

r1 ; r2 ; r3 ; r4 ; r5



## (4) 논리연산자 실습 ##
a <- 100
b <- 5

r1 <- a>=90 & b>=10 #a가 90보다 크거나 같고 b가 10보다 크거나 같다를 모두 성립하는 조건
r2 <- a>=90 | b>=10 #a가 90보다 크거나 같고 b가 10보다 크거나 같다를 둘 중 하나 성립하는 조건
r3 <- !(a>=90)    #괄호의 값이 부정인지 판단하는 명령문
r1 ; r2 ; r3

## (5) cat() 함수와 print() 함수 ##
x <- 10
y <- 20
z <- x+y
cat("x와 y의 덧셈의 결과는\n",z,"입니다.")  # \n은 엔터키 역할로 줄 바꿈
print(z)


##############################################################
##                [2장] R 프로그램 변수 유형                ##
##############################################################
    
## (1)  변수 생성 예제 ##
korea_travel1 <- "서울" #변수 korea_travel1에 값 서울로 초기화
korea_travel1          #korea_travel1의 값 확인
korea.travel2 <- "제주" #변수 korea.travel2에 값 제주로 초기화
korea.travel2          #korea.travel2의 값 확인
KOREA_TRAVEL1 <- "부산"   #변수 KOREA_TRAVEL1에 값 부산으로 초기화
KOREA_TRAVEL1            #변수 KOREA_TRAVEL1의 값 확인
KOREA.days=5    #변수 KOREA.days에 값 5로 초기화
KOREA.days      #변수 KOREA.days의 값 확인  
    
## (2) c()를 활용한 벡터 객체 생성 ##
value1 <- c(1:10)
value1

1:10  #c()함수와 동일

value2 <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
value2

value3 <- c(T, T, F, TRUE, FALSE, T, F)
value3

value4 <- c("만두", "김치찌개", "짬뽕", "돈까스")
value4

value5 <- c("만두", 1, 5.4, "돈까스") #자료형이 혼재된 경우 모두 문자 처리
value5

value6 <- c(1, 5.4, "돈까스")   #자료형이 혼재된 경우 모두 문자 처리
value6

value7 <- c(1, 5.4, -7, 4.52)   #자료형이 정수값이 실수형으로 처리
value7


## (3) seq()와 rep()를 활용한 벡터 객체 생성 ##
value8 <- seq(1, 20, 2)
value8

value9 <- seq(from=20, to=1, by=-2) #seq(from=시작점, to=끝점, by=간격)
value9

value10 <- rep(1:6, 3)  #rep(반복할 내용, 반복수)
value10

value11 <- rep(x=1:5, each=3)
value11

## (4) paste() 함수
a <- c("부천","인천","서울","김포")
b <- c("강원도", "제주도", "경기도")
paste(a,b, sep="")  
paste(a,b, sep="-")
paste(a,b)
paste(c("대한민국","강산","아름답고","푸르게","푸르게"), collapse="|") #한 변수 내 데이터 값 구분

## (5) substr() 실습
ss <- c("하모니","우연히","해외여행")
ss
substr(ss,1,2)
substr("대한민국동해남해서해바다", 1, 6)


## (6)  union(), setdiff(), intersect()를 활용한 벡터 데이터 처리 ##
x <- c(1, 3, 6, 7, 9, 10)
y <- c(2, 4, 6, 8, 10)
z1 <- union(x, y)  #x와 y 변수의 합집합
x ; y ; z1
z2 <- setdiff(x, y)  #x 변수에는 있지만, y 변수에는 없는 값
x ; y ; z2
z3 <- intersect(x, y)  #x, y 변수에 공통으로 있는 값
x ; y ; z3

## (7) mode( ), class( ), typeof( ) 함수를 활용하여 변수의 형태 확인하기
value1 <- c(1:10)
value1 ; mode(value1) ; class(value1) ; typeof(value1)
value3 <- c(T, T, F, TRUE, FALSE, T, F)
value3 ; mode(value3) ; class(value3) ; typeof(value3)
value4 <- c("만두", "김치찌개", "짬뽕", "돈까스")
value4 ; mode(value4) ; class(value4) ; typeof(value4)
value5 <- c(1, 5.4, -7, 4.52)
value5 ; mode(value5) ; class(value5) ; typeof(value5)

## (8) matrix( ) 함수를 이용한 1차원 객체 생성
a <- c(1:5)
m1 <- matrix(a)  #matrix(c(1:5))와 동일
m1 

## (9) matrix( ) 함수와 nrow 속성을 이용한 2차원 객체 생성
m2 <- matrix(c(1:10), nrow=2)
m2
m3 <- matrix(c(1:13), nrow=3)
m3
m3[1,]   #m3[행, 열]
m3[,5]
m3[2,3]  
m3[1,c(2:5)]

## (10) matrix( ) 함수와 ncol 속성을 이용한 객체 생성

m4 <- matrix(c(1:10), ncol=2)
m4

m5 <- matrix(c(1:10), ncol=3)
m5


## (11) matrix( ) 함수와 nrow ・ byrow 속성을 이용한 객체 생성
m6 <- matrix(c(1:16), nrow=2, byrow=TRUE)
m6
m7 <- matrix(c(1:16), nrow=2, byrow=FALSE)
m7


## (12) matrix( ) 함수와 ncol ・ byrow 속성을 이용한 객체 생성

m8 <- matrix(c(1:10), ncol=2, byrow=TRUE)
m8
m9 <- matrix(c(1:10), ncol=2, byrow=FALSE)
m9
length(m7) ; length(m9)
ncol(m9) ; nrow(m9)

## (13) apply() 함수 활용하기
m7 <- matrix(c(1:16), nrow=2, byrow=FALSE)
m7
apply(m7, 1, max)   #행 단위로 가장 큰 값을 구하기
apply(m7, 1, min)  #행 단위로 가장 큰 작은 값을 구하기
apply(m7, 2, sum)   # 열 단위로 각 열의 값을 합계로 구하기


## (14) matrix( ) 함수에 이름을 지정하기 1
m9 <- matrix(c(1:10), ncol=2, byrow=FALSE)
m9
colnames(m9) <- c("한국인", "외국인")
m9   


## (15) matrix( ) 함수에 이름을 지정하기 2

rownames(m9) <- c("서울", "제주", "부산", "강원", "전주")
m9
m9[,'한국인']  #m9[,1]과 동일결과

m9['부산',]
m9['제주',1]
m9['제주','외국인']

## (16) rbind( )와 cbind( )를 이용한 객체 생성
x1 <- c(1:5)
y1 <- c(31:35)
z1 <- rbind(x1, y1) 
z1

z2 <- cbind(x1, y1) 
z2

## (17) Array를 이용한 객체 생성
val <- c(1:10)
arr <- array(val, c(3,3,3))
arr

arr[1,,] ; arr[,2,3] ; arr[1,3,] ; arr[,,2]


## (18) data.frame() 함수를 이용한 객체 생성
df1 <- data.frame(x=c(1:3), y=seq(2, 6, 2), z=c("가","나","다"))
df1
df2 <- data.frame(x=c(1:3), y=seq(2, 8, 2), z=c("가","나","다","라"))
df2


## (19) c() 함수를 data.frame( )으로 객체 생성
num <- c(1,2,3)
na <- c("홍길동", "류현진", "박찬호")
add <- c("서울시", "제주도" , "경기도")
mo <- c(500, 300, 400)
gg1 <- data.frame("NO"=num, "이름"=na, "주소"=add, "용돈"=mo)
gg1

## (20) matrix() 함수를 data.frame( )으로 객체 생성
imsi1 <- matrix(
     c(1, "홍길동", "서울시", 500,
             2, "류현진", "제주도", 300,
             3, "박찬호", "경기도", 400), 3, byrow=TRUE)
imsi1

gg2 <- data.frame(imsi1)
colnames(gg2) <- c("NO", "이름", "주소", "용돈")
gg2


## (21) 데이터의 구조 확인하기
str(gg1) #데이터프레임 객체의 데이터 구조 살펴보기
gg1$이름
names(gg1)
ncol(gg1) ; nrow(gg1) ; gg1[c(2:3), 3]


## (22) subset() 함수를 활용하여 data.frame 부분 객체 생성하기
df3 <- data.frame(x=c(1:5), y=seq(2, 10, 2), z=c("가","나","다","라","마"))
df3

sub1 <- subset(df3, x>=3) #x가 3 이상인 행을 대상으로 subset 생성
sub1

sub2 <- subset(df3, x>=3 & y>=4)  #2개 조건의 조건을 and 연산으로 계산
sub2

sub3 <- subset(df3, x>=3 | y>=4)  #2개 조건의 조건을 or 연산으로 계산
sub3


## (23) merge() 함수를 활용하여 두 개 이상의 데이터프레임 병합하기
na <- data.frame("번호"=c(1:4), "성명"=c("홍길동", "류현수", "박찬일","나최고"))
tel <- data.frame("번호"=c(2,3,5,7), "전화"=c("01092925678", "01090901234", "01082829292","01012345678"))
user1 <- merge(na, tel, by.x="번호", by.y="번호")
user1

## (24) 행과 열의 합계와 평균 계산
a <- c(11:15)
b <- c(21:25)
c <- c(41:45)
x <- data.frame(a,b,c)
colnames(x) <- c("A제품 판매", "B제품 판매","C제품 판매")
rownames(x) <- c("서울","경기","대전","대구","광주")
x
colSums(x[,-4])   # 열별 합계
rowSums(x[-6,]) # 행별 합계
colMeans(x[,-4])  # 열별 평균
rowMeans(x[-6,])  # 행별 평균


## (25) list() 함수 생성 1
lst1 <- list(5.254, "휴가철", c(2,3,4,5))
lst1
lst1[[2]]
lst1[[3]][2]


## (26) list() 함수 생성 2
a1 <- c(1:10)
b1 <- matrix(1:10,2, 5)
c1 <- c("첫번째", "두번째")
lst2 <- list(a=a1,b=b1, c=c1)
lst2
lst2$a


## (27) c() 함수로 결합
lst3 <- list(d=2:10*10)
lst3

lst23 <- c(lst2,lst3)
lst23

## (28) list() 함수로 결합
sco1 <- list(60,70,80,90)
sco2 <- list(c("a","b"))
sco1[sco1>=80]

sco12 <- list(sco1, sco2)
sco12

## (29) unlist() 함수
unlist(sco1)
unlist(sco2)
unlist(sco12)


## (30) lapply() 함수와 sapply() 함수
a <- list(c(1:5))
b <- list(c(112:120))
lapply(c(a,b), mean)
sapply(c(a,b), mean)

## (31)  Factor 데이터 구조 실습
h <- c("서울","부산","서울","서울","부산","경기","서울","서울","경기","제주","제주","경기")  
h
h.new <- factor(h)     #h변수를 factor로 변환
h.new
h[3]  
h.new[3]    #h.new의 3번째 값 출력
levels(h.new)
h.i <- as.integer(h.new)        #문자값을 숫자로 바꾸어 h.i로 저장
h.i
unique(h.i)   #Vector에 저장된 값들의 종류를 알고 싶을 경우 사용되는 함수
h.new[7] <- "울릉도"   #기존 Factor 범주에 없는 경우 새로운 범주값을 추가할 수 있다.
h.new[7] <- "제주"   #기존 Factor 범주에 제주가 있으므로 7번째 값을 제주로 변경이 가능하다.
h.new[7]


## (32) 데이터 타입 확인
a <- c(11:13)
b <- c(21:23)
c <- c("서울","인천")  
x <- data.frame(a,b)
x
class(x)
class(a)
class(c)


## (33) 데이터형 확인
x <- c(10,20,"30")
x
is.vector(x)
is.numeric(x)
is.character(x)

s <- 10:20
t <- TRUE
is.character(s)
is.numeric(s)
is.logical(t)

## (34) 데이터형 변환 1
x <- c(10,20,"30")   # 30은 문자열로 c()함수는 모두 문자열로 저장됨
x
class(x)   # x의 변수 타입이 문자형으로 지정
y1 <- x*3    #x의 변수 타입이 문자이므로 에러 발생
y2 <- as.numeric(x)*3        #x의 변수 타입을 숫자형으로 변환하여 3을 곱하기를 진행함
y2

## (35) 데이터형 변환 2
area <- c("서울","서울","부산","제주","광주","제주")
plot(area)   # 문자로 된 값들만 차트로 작성하지 못합니다.
area_adj <- as.factor(area)   # 문자형을 factor 데이터 타입으로 변환
table(area_adj)
plot(area_adj)  
mode(area)
mode(area_adj)


##############################################################
##                [3장] 데이터 입력 및 확인하기             ##
##############################################################

## (1) scan() 함수
fig <- scan()  # 분석자가 직접 키보드로 ‘숫자’ 입력하기
fig
sum(fig)

chr <- scan(what=character())
chr


## (2) edit() 함수
dfx <- data.frame()
dfx <- edit(dfx)
dfx

## (3) setwd()와 getwd() 함수
setwd("c:/Data Analysis/r_exam/")  #분석자의 r프로그래밍 파일 저장위치 설정
getwd()   #분석자의 r프로그래밍 파일 저장위치 확인

## (4) 외부 데이터 가져오기 1
setwd("c:/Data Analysis/r_exam/")  #분석자의 r프로그래밍 파일 저장위치 설정
getwd() 
dfs1 <- read.csv("student_list.csv")
dfs1

setwd("c:/Data Analysis/r_exam/")  #분석자의 r프로그래밍 파일 저장위치 설정
getwd() 
dfs2 <- read.table(file="student_list.txt", header=T)
dfs2


## (5) 외부 데이터 가져오기 2
setwd("c:/Data Analysis/r_exam/")  #분석자의 r프로그래밍 파일 저장위치 설정
getwd() 
nc <- scan("숫자값.txt")
nc


## (6) 외부 데이터 가져오기 3
install.packages("readxl")
library(readxl)
setwd("c:/Data Analysis/r_exam/")
sl_excel <- read_excel(path='student_list.xlsx', sheet='student_list')
sl_excel

str(sl_excel)

## (7) sink(), write.table(), write.csv(), write_xlsx() 함수로 파일로 저장하기 1
setwd("c:/Data Analysis/r_exam/")
sink("task.txt")   # 작업 결과물을 저장하기 위한 파일명을 작업시작전에 미리 명령어로 선언

dfs1 <- read.csv("student_list.csv")
dfs1
dfs2 <- read.table(file="student_list.txt", header=TRUE)
dfs2
dfx <- rbind(dfs1, dfs2)
dfx

sink()  #작업된 결과물 dfs1, dfs2, dfx의 결과 내용을 task.txt에 저장
write.table(dfx, "student_combine.txt", row.names=TRUE, quote=FALSE)
write.csv(dfx, "student_combine.csv", row.names=TRUE)

install.packages("writexl")  # 엑셀파일로 저장할 수 있게 도와주는 별도 패키지
library(writexl)
write_xlsx(dfx,path="student_combine.xlsx", col_names=TRUE)


## (8)  데이터 확인하기 1 - 도로교통공단_사고유형별 월별 교통사고(2018).csv
setwd("C:/Data Analysis/r_exam")
data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
head(data, 7)  #데이터의 상단에서 7개 데이터만 추출하여 확인
tail(data, 5) #데이터의 하단에서 5개 데이터만 추출하여 확인


## (9) 데이터 확인하기 2 - 도로교통공단_사고유형별 월별 교통사고(2018).csv
data$사고건수   #data[,"사고건수"]와 동일한 결과를 제시한다.
data[,c("사고건수","경상자수")]  #data[,c(5,8)]과 동일한 결과를 보여준다.
#data[,c(5,8)]
data[1:3,] #head(data, 3)과 동일한 결과를 보여준다.


## (10) 데이터 확인하기 – 불법 주정차 단속현황 데이터
setwd("C:/Data Analysis/r_exam")
data <- read.csv("서울특별시_강남구_불법주정차단속현황_20210208 - 결측치.csv")
data
View(data)

## (11) 데이터 앞부분과 뒷부분 확인하기 – 불법 주정차 단속현황 데이터
head(data, 6)  #head(변수명, 데이터확인 개수)
tail(data, 6)   #tail(변수명, 데이터확인 개수)


## (12) 데이터의 특정 변수와 칼럼으로 조회– 불법 주정차 단속현황 데이터
data$동명
length(data$동명)
data$부과건수
data["동명"]  #data[2] 명령문은 data[“동명”]과 동일한 결과를 보여준다.
# data[2] 
data[,c("견인건수","부과건수")]  # data[c(4,3)] 명령문과 동일한 결과를 보여준다.
# data[c(4,3)] 



##############################################################
##                [4장] 데이터 입력 및 확인하기             ##
##############################################################

## (1) R Packages 설치
install.packages("corrgram") # corrgram() 함수는 상관계수를 시각화하는 데 유용

## (2) R Packages 사용
library(corrgram)  # corrgram() 함수는 상관계수를 시각화하는 데 유용
require(corrgram)
search()

library(car) #car 패키지 설치가 안되어 있으면 오류가 발생한다.
require(car) #car 패키지 설치가 안되어 있으면 오류가 발생한다.


## (3) R Packages 설치와 사용
install.packages("cowsay")
library(cowsay)
say(what="안녕하세요. 여러분", by="rabbit", what_color='blue', by_color='blue')


## (4) R Packages 업데이트 및 제거
update.packages("corrgram")
remove.packages("corrgram")

## (5) dplyr() 패키지 실습 1
install.packages("dplyr")
library(dplyr)
t_data <- read.csv("C:/Data Analysis/r_exam/도로교통공단_사고유형별 월별 교통사고(2018).csv")
t_data %>% head()  #전체 데이터세트 중 첫째 데이터부터 6개의 관찰 데이터를 화면에 표시
t_data %>% subset(사고건수>=6500 & 부상신고자수>=700) 

tbl_df(t_data) #현재 R의 콘솔 창 크기에서 볼 수 있을 만큼 행과 칼럼을 표현

filter(t_data, 사고유형중분류=="횡단중"&사망자수>=70) 

arrange(t_data, desc(사고건수)) #빅데이터에서 특정 칼럼을 정렬시켜주는 함수

select(t_data, 사고유형, 부상신고자수) #빅데이터의 데이터 셋의 특정 칼럼을 기준으로 데이터 검색

t_data2 <- mutate(t_data, 비율=사망자수/사고건수) #빅데이터에서 특정 칼럼을 추가시켜주는 함수
t_data2


summarise(t_data, mean(사고건수))  #빅데이터에서 특정 칼럼을 대상으로 기술통계량 계산

# 빅데이터에서 범주형 칼럼을 대상으로 그룹화하는 함수
group_by(t_data, 사고유형대분류) %>%
     summarise(mean_math = mean(사고건수), 
                             sum_math = sum(사고건수),
                             n = n())

## (6) dplyr() 패키지 실습 2
library(dplyr)
head(t_data,3)

x <- filter(t_data, 경상자수>=7000)  #경상자수가 7000명이상인 데이터만 추출하여 x변수에 저장
x <- x[,c(4,8)]  #x변수에서 월, 경상자수 칼럼만 추출하여 저장
x

y <- filter(t_data, 부상신고자수>=650) #부상신고자수가 650명이상인 데이터만 추출하여 y변수에 저장
y <- y[,c(4,9)] #y변수에서 월, 부상신고자수 칼럼만 추출하여 저장
y

inner_join(x,y, by="월")

left_join(x,y, by="월")
right_join(x,y, by="월")
full_join(x,y, by="월")

df_rows <- bind_rows(x,y)
df_rows

df_cols <- bind_cols(x,y)  #x 변수와 y 변수의 칼럼의 데이터 값 개수가 달라서 오류가 발생한다.

x <- x[c(1:6),]  #x 변수 데이터수를 y변수와 일치화하고자 6개로 데이터만 추출하여 x변수 재저장
df_cols <- bind_cols(x,y)
df_cols

df_cols_rename <- rename(df_cols, 경상자_월=월...1)
df_cols_rename <- rename(df_cols_rename, 부상신고자수_월=월...3)
df_cols_rename

## (7) dplyr() 패키지 실습 - 서울특별시_강남구_불법주정차단속현황

library(dplyr)
setwd("C:/Data Analysis/r_exam")
g_data <- read.csv("서울특별시_강남구_불법주정차단속현황_20210208.csv", header=TRUE)
g_data %>% head(3)  #head(g_data, 3) 명령문과 동일한 결과

g_data %>% subset(부과건수>=60000 | 견인건수>=7000) 
#filter(g_data, 부과건수>=60000 | 견인건수>=7000)과 동일한 결과

tbl_df(g_data)
arrange(g_data, desc(부과건수))
select(g_data, 부과건수, 단속원금.원.) 

g_data2 <- mutate(g_data, 총건수=부과건수+견인건수) 
g_data2

summarise(g_data, mean(단속원금.원.))

group_by(g_data, 연도) %>%
    summarise(부과건수_mean = mean(부과건수), 
                 부과건수_sum = sum(부과건수),
                       n = n())


x <- filter(g_data, 부과건수>=10000, 연도==2019)
x <- x[,c(2,3)]
x

y <- filter(g_data, 견인건수>=1000, 연도==2019)
y <- y[,c(2,4)]
y

inner_join(x,y, by="동명")
left_join(x,y, by="동명")
right_join(x,y, by="동명")
full_join(x,y, by="동명")

## (8) reshape2 패키지 실습 – dcast()

install.packages("reshape2")
library(reshape2)
t_data <- read.csv("C:/Data Analysis/r_exam/도로교통공단_사고유형별 월별 교통사고(2018).csv")
t_data %>% head()  #전체 데이터세트 중 첫째 데이터부터 6개의 관찰 데이터를 화면에 표시

t_data2 <- dcast(t_data, 사고유형대분류~월, value.var = '경상자수',sum)
t_data2

t_data3 <- t_data[c(1:6),c(1,4,8)]  #1~6월개월치만 사고유형대분류, 월, 경상자수 칼럼만 추출하여 저장
t_data3  

t_data4 <- melt(t_data3, id="사고유형대분류")
t_data4

## (9)  reshape2 패키지 실습 – 서울특별시 강남구 불법주정차단속현황
setwd("C:/Data Analysis/r_exam")
g_data <- read.csv("서울특별시_강남구_불법주정차단속현황_20210208.csv")
head(g_data)

g_data2 <- dcast(g_data, 동명~연도, value.var = '부과건수',sum)
g_data2      

g_data3 <- g_data[c(1:3),c(1:5)]
g_data3

g_data4 <- melt(g_data3, id="동명")
g_data4

## (10) if~else문 실습
x <- runif(1)     #0과 1식사의 난수를 생성해서 x에 할당한다.
x
if(x<0.5) print(x+10) else print(x+5) 
ifelse(x<=10, "10이하" ,"10이상")

type <- 'S'
ifelse (type == 'S', '300만원', '100만원')

a <- 100
b <- 5

if(a+b>=100)
     {
         cat("a+b의 결과는 100 이상입니다. a+b=", a+b)
       }else{
           cat("a+b의 결과는 100 이하입니다. a+b=", a+b)
         }

ifelse(a+b>=100, "100이상" ,"100이하")


xx <- runif(1)
xx <- (xx-0.5)
xx

if(xx<0){
     print("xx의 값은 음의 값이다:")
     print(xx)
   }else if(xx>0) {
       print("xx의 값은 양의 값이다:")
       print(xx)
     }



## (11) switch() 함수
xxx <- "매우우수"
xxx

switch(xxx,
                 "매우우수"=print("A+"),
                 "우수"=print("A0"),
                 "보통"=print("B+"),
                 "미흡"=print("C+"),
                 "매우미흡"=print("복습")
          )


xxx <- c("매우우수","보통")
switch(xxx,
                 "매우우수"=print("A+"),
                 "우수"=print("A0"),
                 "보통"=print("B+"),
                 "미흡"=print("C+"),
                 "매우미흡"=print("복습")
          )




## (12) which() 문 실습
점수 <- c(76, 80, 90, 95, 45, 42, 53, 60, 67, 73)
which(점수==67)  # 점수가 67이 있는 위치값
which(점수==80)  # 점수가 80이 있는 위치값
which(점수==83) # 점수가 83이 있는 위치값 – 위치값이 없으므로 0을 반환
which.min(점수)  # 최소 점수가 있는 위치값
which.max(점수) # 최대 점수가 있는 위치값
ss <- which(점수<=70)   # 점수가 70이하인 값들의 위치값
ss
점수[ss] <- 65       # 점수가 70이하인 위치값들에 65로 점수를 변환
점수[ss]
점수


## (13) for문 
sum <- 0
i=1
for(i in seq(1,10, by=1)) sum <- sum+i
sum
i=1
for(i in 5){     # 최종 5*2로 계산된 값을 출력합니다. 
     print(i*2)
   }

 i=1
 for(i in 1:5){      # 1~5까지 계산된 값을 각각 출력합니다.
     print(i*2)
   }


## (14) 중첩 for()문
i=2
j=1
for(i in 2:5){  #구구단 앞부분
      for(j in 1:5) #구구단 뒷부분
         cat(i*j," ")
   }
 
 
## (15) while() 실습
sum <-0
i<-0 
while(i<=10){
     sum <- sum+i
     i=i+1
   }
sum

## (16) 사용자 정의 함수
f1 <- function() {
  
       print("행복합니다.")
    
    }  
f1         #f1을 확인하게 되면 사용자정의함수가 어떻게 작성되어 있는지 확인시켜줍니다.
f1()


f2 <- function(x, y) { 
     sum <- x+y
     sub <- x-y
     mul <- x*y
     div <- x/y
     print(sum)
     print(sub)
     print(mul)
     print(div)
  }
f2(20,30)

cal <- function(i){
  
       for(x in i) {
           cat(x,"단","\n")
           
             for(y in 1:9){
                 cat(x, "*", y, "=", x*y,"\n")
               }
         }
   }
 
cal(2)
cal(2:3)


##############################################################
##                [5장] 차트 시각화                         ##
##############################################################

vis <- c(95,70,65,80,62,45,80,97)
names(vis) <- c("철수","영희","두철","희민","주희","영수","민지","주영")
vis

##(1) 단일 데이터 시각화
#막대차트 작성
barplot(vis,ylim=c(0,100), col=rainbow(8), border=0.4, xlab="성명", ylab="점수", main="빅데이터 성적")

barplot(vis, horiz=TRUE, xlim=c(0,100), space=0.8, col=c("blue","purple"), border=0.4,
                cex.names=1, xlab="점수", ylab="성명", main="빅데이터 성적")

#도트 플롯 차트 시각화
dotchart(vis, color=c("blue","red"), lcolor="gray", pch=1:8, labels=names(vis),
                   ylab="성명", xlab="점수", main="빅데이터 성적", cex=1.2)

#원형 차트 시각화
pie(vis, border=1, radius=1, edges=100, 
           clockwise = T, main="빅데이터 성적", cex=1.2, label=paste(names(vis),vis,"점"))

#히스토그램 시각화
par(mfrow=c(1,2)) #1행 2열 차트로 표현
hdata <- c(65,83,75,80,77,72,87,67,56,97)
hist(hdata, xlab="점수", col="lightblue", main="빅데이터 점수 히스토그램",
                     freq=TRUE, xlim=c(50,100), border="black", density=100)
hist(hdata, xlab="점수", col="lightblue", main="빅데이터 점수 히스토그램",
                     freq=FALSE, xlim=c(50,100))
lines(density(hdata), col="red")  #밀도 기준으로 라인 추가
x <- seq(50, 100, 10)
curve(dnorm(x,mean=mean(hdata), sd=sd(hdata)),col="blue",add=T) #정규분포 추정 곡선 추가

##(2) 복합 데이터 시각화

a_score <- c(95,70,65,80,62,45,80,97)
b_score <- c(70,85,72,70,65,55,48,95)
names(a_score) <- c("철수","영희","두철","희민","주희","영수","민지","주영")
names(b_score) <- c("철수","영희","두철","희민","주희","영수","민지","주영")

#막대차트 시각화
par(mfrow=c(1,2)) #1행 2열 차트로 표현
barplot(a_score, horiz=T, xlim=c(0,100), col=rainbow(8), border=0.4, xlab="성명", ylab="점수",
                             main="빅데이터 성적")
legend(60,10,names(a_score),cex=0.8, fill=rainbow(8))
barplot(b_score,horiz=T, xlim=c(0,100), col=rainbow(8), border=0.4, xlab="성명", ylab="점수", 
                             main="통계 성적")
legend(60,10,names(b_score),cex=0.8, fill=rainbow(8))

#박스 플롯 시각화
c_score <- cbind(a_score,b_score)
colnames(c_score) <- c("빅데이터 점수","통계 점수")
c_score 

par(mfrow=c(1,1)) 
boxplot(c_score, col=c("yellow","green"),  ylim=c(40,100))
abline(h=75, lty=3, col="red")  #75점을 기준선으로 라인작성

#산점도 시각화
plot(c_score, col="Red", axes=TRUE, ann=TRUE, type="p", lwd=10, main="빅데이터-통계 점수현황")
par(new=TRUE) #기존 차트를 남겨두고 새롭게 차트 추가
line_chart=1:100
plot(line_chart, col="blue", axes=FALSE, ann=FALSE, type="l")
text(x=50,y=60, "대각선", col="blue") # 차트에 텍스트 추가

#산점도 행렬 시각화
c_no <- c(1,1,1,1,2,2,2,2) 
d_score <- data.frame(a_score,b_score,c_no)
colnames(d_score) <- c("빅데이터 점수","통계 점수","반")
d_score

par(mfrow=c(1,1)) 
pairs(d_score[d_score$반==1,1:3], pch=c(1:4), col=c(1:4), cex=2)
# 철수는 o, 영희는 △, 희민이는 x, 두철은 +로 표시기호로 구분하여 각 색상별로 데이터의 관계를 
# 확인할 수 있다.

## (3) 차트 시각화 응용
csv <- read.csv("C:/Data Analysis/r_exam/도로교통공단_사고유형별 월별 교통사고(2018).csv")
csv2 <- csv[c(1:12),]  #사고유형중 차대사람~횡단중 1년간(12개월) 데이터만 추출
csv2

#x축인 월별로 부상신고자의 인원수를 차트로 시각화로 표현하였다. 3월에 부상신고자수가 높게 나타났다.
barplot(부상신고자수~월, data=csv2, horiz=F, ylim=c(0,100), 
                             space=1,  col="red",border=0.4, density=100,
                             cex.names=1, xlab="월별", ylab="부상신고자수", main="차대사람~횡단중-부상신고자수")


#y축인 월별로 부상신고자의 인원수를 차트로 표현하였고, 3월이 다른 달보다 부상신고자사 높다.
barplot(부상신고자수~월, data=csv2, horiz=T, xlim=c(0,100), 
                               space=1,  col="blue",border=0.4, density=100,
                               cex.names=1, xlab="부상신고자수", ylab="월별", main="차대사람~횡단중-부상신고자수")

par(mfrow=c(1,2)) #1행 2열 차트로 표현
#x축을 월별로 사고건수와 부상신고자의 인원수를 차트로 표현하였다.
#사고건수 시각화로는 10월에 높은 수치를 보이고 있고, 부상신고자수는 3월이 높은 수치를 보인다.
barplot(사고건수~월, data=csv2, horiz=F, ylim=c(0,2000), border=0.4, col="red", 
                       main="차대사람~횡단중-사고건수")
barplot(부상신고자수~월, data=csv2, horiz=F, ylim=c(0,100),border=0.4, col="blue", 
                       main="차대사람~횡단중-부상신고자수")

# y축을 월별로 부상신고자의 인원수를 도트로 시각화하여 세부 내용을 살펴보면 3월은 80명에 위치하고
# 있으며 7월에는 50명 이하인 47명에 위치해 있어 다른 달보다 낮은 수치를 시각화를 통해 확인된다.
par(mfrow=c(1,1))
dotchart(csv2$부상신고자수,gdata=csv2, color=c("blue","red"), lcolor="gray", pch=1, 
                    labels=1:12, ylab="월", xlim=c(40,90), xlab="부상신고자수", main="부상신고자수", cex=1)

#사고건수를 월별로 데이터가 어느정도로 구서되어 있는지 원형차트로 시각화하였다.
pie(csv2$부상신고자수, border=1, radius=0.8, edges=0, clockwise = T, main="부상신고자수", 
            cex=1.2, label=paste(csv$월,"월,",csv2$부상신고자수,"건"))

# 차대사람사고 중에 횡단중에 사고현황을 사고별로 비교하는 시각화를 진행하였다.
# 데이터는 총 12개월의 사고건수, 사망자수, 중상자수 경상자수별로 비교하는 시각화를 진행하였으며 
# 데이터의 표식을 12개로 지정하여 색상을 지정하여 칼럼 간 관계가 어떻게 구성되는지 시각화로   
# 이해할 수 있다.
pairs(csv2[,5:8], pch=c(1:12), col=c(1:12), cex=1)

#박스 플롯 시각화
csv3 <- csv2[c(1:12),c(7:8)]  #중상자수와 경상자수만 추출
csv3
mean(csv3$중상자수); mean(csv3$경상자수)
boxplot(csv3)
abline(h=750, lty=5, col="red")
# 중상자와 경상자수의 데이터의 분포를 박스 플롯으로 시각화를 진행하였고 경상자수보다 중상자수가
# 더 높은 수치에 분포되어 있는 모습을 확인할 수 있으며 750을 기준으로 중상자수는 평균이 750보다
# 높으며 경상자수는 750보다 낮은 것을 시각화로 확인할 수 있다.

#산점도 시각화 1
par(mfrow=c(1,1)) #1행 1열 차트로 표현
plot(csv3, col="Red", axes=TRUE, ann=TRUE, type="p", lwd=6, main="2018 중상자수-경상자수 현황")
par(new=TRUE) #기존 차트를 남겨두고 새롭게 차트 추가
line_chart=1000:2000
plot(line_chart, col="blue", axes=FALSE, ann=FALSE, type="l")
text(x=600, y=1650, "선형", col="blue")
# x축을 중상자수, y축을 경상자수로 지정하여 두 칼럼 간의 데이터가 어떻게 관계를 가지고 있는지
# 확인하는 시각화로 선형을 기준으로 데이터가 모여있지 않고 흩어져 있는 모습을 확인할 수 있다.


#산점도 시각화 2
par(mfrow=c(2,2)) #2행 2열 차트로 표현
plot(csv3, col="Red", axes=TRUE, ann=TRUE, type="l", lwd=1, main="2018 중상자수-경상자 현황")
plot(csv3, col="Red", axes=TRUE, ann=TRUE, type="o", lwd=1, main="2018 중상자수-경상자 현황")
plot(csv3, col="Red", axes=TRUE, ann=TRUE, type="h", lwd=1, main="2018 중상자수-경상자 현황")
plot(csv3, col="Red", axes=TRUE, ann=TRUE, type="s", lwd=1, main="2018 중상자수-경상자 현황")
# plot(csv3, col="Red", axes=TRUE, ann=TRUE, type="p", lwd=6)와 동일한 결과이며 단지 type을 
# 변경하였을 때 시각화로 표현되는 방법이 다름을 확인할 수 있다.

#히스토그램 시각화
csv4 <- csv2[c(1:12), 5]  #1월부터12월까지의 ‘사고건수’ 칼럼(5번째 칼럼)만 데이터로 별도 추출
csv4

par(mfrow=c(1,2)) #1행 2열 차트로 표현
hist(csv4, xlab="사고건수", col="lightyellow", freq=TRUE, main="사고건수", labels=TRUE,
            border="pink")

hist(csv4, xlab="사고건수", col="lightyellow", freq=FALSE, main="사고건수", labels=TRUE, 
            border="pink")
lines(density(csv4), col="red")  #밀도 기준으로 라인 추가
x <- seq(1300, 1800, 100)
curve(dnorm(x,mean=mean(csv4), sd=sd(csv4)),col="blue",add=T) #정규분포 추정 곡선 추가
# 1300~1400 구간대의 데이터는 3개, 1400~1500 구간대의 데이터는 1, 1500~1600 구간대의 
# 데이터는 4개 등으로 나타나 1300~1800까지 구간(계급)별로 데이터를 시각화를 확인할 수 있다.
# 빨간색의 밀도선과 파란색의 정규분포 추정 곡선으로 시각화된 히스트그램을 살펴보면 정규분포를
# 만족하는 것으로 추정할 수 있다.


## (4) lattice 패키지를 이용한 시각화 응용

install.packages("lattice")
library(lattice)

setwd("C:/Data Analysis/r_exam")
csv <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
table(csv$사고유형대분류)  #203개의 데이터(차대사람60,차대차60,차량단독80,철길건널목3)

min(csv$경상자수);max(csv$경상자수)
min(csv$중상자수);max(csv$중상자수)
min(csv$사망자수);max(csv$사망자수)

histogram(~경상자수,data=csv) #hisogram(~칼럼명 | 그룹핑할 칼럼명, 변수명)
#경상자수의 사상자 수는 0~1000명이하의 데이터가 상대적으로 매우 높은 비율을 차지하고 있다.

histogram(~경상자수 | 사고유형대분류,data=csv)
# 차량단독, 철길건널목, 차대사람, 차대차로 구분하여 경상자수를 확인하면 차량단독과 철길건널목은 
# 0~1000명이하 데이터에 수렴하고 있다. 차대사람 0~1000명의 데이터와 1001~2000명 이하의 
# 데이터가 존재하는 것을 확인할 수 있으며 차대차에서는 경상자수가 0~8000명 사이에 고르게 
# 분포되어 있다.
  

# 밀도 차트는 히스토그램에서 나타난 구간의 도수값을 곡선으로 시각화시켜준다.
# densityplot(~칼럼명 | 그룹핑할 칼럼명, 변수명, auto.key=범례여부 표시, plot.points=밀도 점 표시
densityplot(~경상자수,data=csv) #histogram(~경상자수,data=csv)의 동일 결과를 곡선으로 시각화


densityplot(~경상자수 | 사고유형대분류,data=csv, auto.key=TRUE, group=사고유형대분류, 
            plot.point=TRUE) #histogram(~경상자수 | 사고유형대분류,data=csv)를 곡선으로 시각화
# 사고유형대분류별로 경상자수의 도수값을 곡선으로 표현


#barchart(그룹핑칼럼(범주형데이터) ~ 빈도수계산할 칼럼 | 그룹핑할 칼럼, 변수명)
barchart(사고유형~경상자수 | 사고유형대분류, data=csv)

barchart(사고유형~경상자수 | 사고유형대분류, data=csv, layout=c(4,1))

# dotplot(그룹핑칼럼(범주형데이터) ~ 빈도수계산할 칼럼 | 그룹핑할 칼럼, 변수명)
dotplot(사고유형~경상자수 | 사고유형대분류, data=csv) 

  
dotplot(사고유형~경상자수|사고유형대분류, data=csv, layout=c(4,1))

# xyplot(y축칼럼 ~ x축칼럼 | 그룹핑할 칼럼, 변수명, pch=“점 모양”)
xyplot(사망자수~중상자수,data=csv)


xyplot(사망자수~중상자수 | 사고유형대분류,data=csv, pch='♣')

# 조건에 따른 두 변수에 대한 그래프를 작성

coplot(사망자수~중상자수 | 사고건수, data=csv, overlap=0.9, bar.bg=c(num='yellow'), 
                                 col="blue", row=1, number=1, panel=panel.smooth)

coplot(사망자수~중상자수 | 사고건수, data=csv, overlap=0.9, bar.bg=c(num='yellow'), 
                  col="blue", row=1, number=4, panel=panel.smooth)

cloud(사망자수~경상자수*중상자수,data=csv, panel.aspect=1, screen=list(z=20,y=80))


t_group <- equal.count(csv$부상신고자수, number=5, overlap=0)  #5개의 영역으로 범주화
t_group 

xyplot(사망자수~중상자수 | t_group,data=csv, pch='♥')

## (5) ggplot2 패키지를 이용한 시각화

install.packages("ggplot2")
library(ggplot2)

setwd("C:/Data Analysis/r_exam")
csv <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
table(csv$사고유형대분류)  #203개의 데이터(차대사람60,차대차60,차량단독80,철길건널목3)

qplot(경상자수, data=csv, bins=30)
qplot(경상자수, data=csv, fill=사고유형대분류, bins=30)
qplot(경상자수, data=csv, fill=사고유형대분류, geom="bar", color=사고유형대분류)
qplot(경상자수, data=csv, fill=사고유형대분류, geom="boxplot", color=사고유형대분류)

qplot(경상자수, data=csv, fill=사고유형대분류, facets=사고유형대분류~.)
qplot(x=경상자수, y=부상신고자수, data=csv)
qplot(x=경상자수, y=부상신고자수, data=csv, color=사고유형대분류)
qplot(x=경상자수,y=중상자수, data=csv, color=사고유형대분류, shape=사고유형대분류)
qplot(x=경상자수, y=부상신고자수, data=csv, color=사고유형대분류, facets=사고유형대분류~.)


##############################################################
##                [6장] 기술 및 추론 통계분석               ##
##############################################################

## (1) 기술통계 분석을 위해 외부데이터 불러오기 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
setwd("C:/Data Analysis/r_exam/")
data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018)-결측치.csv", header=TRUE)
head(data)
dim(data)  #데이터 갯수와 변수(칼럼) 갯수 확인

## (2) 기술통계 분석(빈도분석) - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
str(data) # 데이터의 구조를 상세히 보여주는 함수
summary(data)
length(data$사고건수) 
table(data$사고유형대분류)
table(data$사고유형중분류)

## (3) 결측치 제거 후 계산 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
length(data$사고건수)  #사고건수 총 데이터 수
summary(data$사고건수)
sum(data$사고건수)  # 결측치가 있는 경우에 사고건수 합계 출력
sum(data$사고건수, na.rm=TRUE)  # na.rm=TRUE를 적용하여 결측치 제거하여 계산
imsi <- na.omit(data$사고건수)  #사고건수 열에 있는 모든 결측치 제거 후 imsi에 저장
sum(imsi)
length(imsi)  # 결측치 제거하고 계산된 총 데이터 수


## (4) 결측치 대체 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
data$사고건수  #결측치 확인
data$사고건수2 = ifelse(!is.na(data$사고건수), data$사고건수, 0)  #결측치를 0으로 대체
data$사고건수2

data$사고건수3 = ifelse(!is.na(data$사고건수), data$사고건수, 
                             round(mean(data$사고건수, na.rm=TRUE),0)) # 결측치를 평균값으로 대체
data$사고건수3
head(data[c("사고건수","사고건수2", "사고건수3")],5)

## (5) 결측치 제거 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
data2 <- data[!is.na(data$사고건수),]  
data2 <- data2[!is.na(data2$사망자수),] 
data2 <- data2[!is.na(data2$중상자수),]
data2 <- data2[!is.na(data2$경상자수),] 
data2 <- data2[!is.na(data2$부상신고자수),] 
data2 <- na.omit(data) #203개 데이터 중 60개 결측치 제거후 143개 데이터 존재
data2 <- na.omit(data2[,-c(10:11)]) #10번칼럼 사고건수2, 11번칼럼 사고건수3 제거후 data2 저장
table(data2$사고유형대분류)

summary(data2)

## (6) 결측치 제거 후 기술통계량(범주형 데이터)  - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
t1 <- table(data2$사고유형대분류)
t1

t2 <- prop.table(t1)
round(t2*100,2)

t3 <- table(data2$사고유형중분류)
t3

t4 <- prop.table(t3)
round(t4*100,2)

## (7) 결측치 제거 후 기술통계량(연속형 데이터) - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
data2$사고건수x = data2$사고건수 #사건건수 원본 데이터 외 별도의 칼럼을 만들어 기술통계량 계산
data2$사고건수x[data2$사고건수 <= 2000] <- "2000건 이하"
data2$사고건수x[data2$사고건수 >= 2001 & data2$사고건수 <= 4000] <- "2001~4000건"
data2$사고건수x[data2$사고건수 >= 4001 & data2$사고건수 <= 6000] <- "4001~6000건"
data2$사고건수x[data2$사고건수 >= 6001] <- "6001건 이상"
t5 <- table(data2$사고건수x)  #사고건수(비율 데이터)를 범주화시킨 칼럼을 토대로 빈도수를 계산
t5

t6 <- prop.table(t5)  #사고건수(비율 데이터)를 범주화시킨 칼럼을 토대로 구성비율을 계산
round(t6*100,2)

data2$부상신고자수x = data2$부상신고자수
data2$부상신고자수x[data2$부상신고자수 <= 200] <- "200건 이하"
data2$부상신고자수x[data2$부상신고자수 >= 201 & data2$부상신고자수 <= 400] <- "201~400건"
data2$부상신고자수x[data2$부상신고자수 >= 401 & data2$부상신고자수 <= 600] <- "401~600건"
data2$부상신고자수x[data2$부상신고자수 >= 601] <- "61건 이상"
t7 <- table(data2$부상신고자수x)
t7

t8 <- prop.table(t7)
round(t8*100,2)

## (8) 기술통계 분석을 위해 외부데이터 불러오기 - 서울특별시_강남구_불법주정차단속현황
setwd("C:/Data Analysis/r_exam/")
g_data <- read.csv("서울특별시_강남구_불법주정차단속현황_20210208 - 결측치.csv", header=TRUE)
head(g_data)
dim(g_data)  #데이터 갯수와 변수(칼럼) 갯수 확인
str(g_data) # 데이터의 구조를 상세히 보여주는 함수
length(g_data$연도)   #연도 데이터의 개수 값 제시
table(g_data$연도)

## (9) 결측치 제거 후 계산 - 서울특별시_강남구_불법주정차단속현황
summary(g_data)
length(g_data$견인건수) 
summary(g_data$견인건수)
sum(g_data$견인건수)
sum(g_data$견인건수, na.rm=TRUE)
imsi <- na.omit(g_data$견인건수)  
sum(imsi)
length(imsi) 


## (10) 결측치 대체 - 서울특별시_강남구_불법주정차단속현황
g_data$견인건수

g_data$견인건수2 = ifelse(!is.na(g_data$견인건수), g_data$견인건수, 0)  #결측치를 0으로 대체
g_data$견인건수2

g_data$견인건수3 = ifelse(!is.na(g_data$견인건수), g_data$견인건수, 
                        round(mean(g_data$견인건수, na.rm=TRUE),0)) # 결측치를 평균값으로 대체
g_data$견인건수3

tail(g_data[c("견인건수","견인건수2", "견인건수3")],5)

g_data2 <- na.omit(g_data) # 데이터에 있는 결측치 제거 후 g_data2 저장
table(g_data2$연도)

g_data2 <- na.omit(g_data2[,-c(6:8)]) 
#6~8번째 칼럼(데이터기준일자, 견인건수 2, 견인건수3) 제거 후 g_data2 저장
summary(g_data2)


## (11) 결측치 제거 후 기술통계량(범주형 데이터)  - 서울특별시_강남구_불법주정차단속현황
g1 <- table(g_data2$연도)
g1

g2 <- prop.table(g1)
round(g2*100,2)

g3 <- table(g_data2$동명)
g3

g4 <- prop.table(g3)
round(g4*100,2)


## (12) 결측치 제거 후 기술통계량(연속형 데이터)  - 서울특별시_강남구_불법주정차단속현황
g_data2$부과건수x = g_data2$부과건수
g_data2$부과건수x[g_data2$부과건수 <= 30000] <- "3만건 이하"
g_data2$부과건수x[g_data2$부과건수 >= 30001 & g_data2$부과건수 <= 40000] <- "3만~4만건"
g_data2$부과건수x[g_data2$부과건수 >= 40001 & g_data2$부과건수 <= 50000] <- "4만~5만건"
g_data2$부과건수x[g_data2$부과건수 >= 50001] <- "5만건 이상"
g5 <- table(g_data2$부과건수x)  
g5

g6 <- prop.table(g5)
round(g6*100,2)


g_data2$견인건수x = g_data2$견인건수
g_data2$견인건수x[g_data2$견인건수 <= 300] <- "300건 이하"
g_data2$견인건수x[g_data2$견인건수 >= 301 & g_data2$견인건수 <= 600] <- "301~600건"
g_data2$견인건수x[g_data2$견인건수 >= 601 & g_data2$견인건수 <= 800] <- "601~800건"
g_data2$견인건수x[g_data2$견인건수 >= 801] <- "801건 이상"
g7 <- table(g_data2$견인건수x)  
g7

g8 <- prop.table(g7)
round(g8*100,2)


## (13) 정규성 검정
x <- c(12,14,10,11,14,10,16,18,16,22,22,15,9,12,27) # 스마트폰 판매수
summary(x)
mean(x)
shapiro.test(x)  #정규성 검정

par(mfrow=c(1,2))
hist(x)
qqnorm(x) #정규분포의 QQ plot을 그리는 함수
qqline(x,col='blue')

## (14) 단일 표본평균 차이 검정
t.test(x, mu=22, alternative="two.sided", conf.level=0.95) #양측검정
t.test(x, mu=22, alternative="less", conf.level=0.95) #단측검정 (22보다 작다)
t.test(x, mu=22, alternative="greater", conf.level=0.95)  #단측검정 (22보다 높다)


## (15) 정규성 검정 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
par(mfrow=c(1,2))
hist(t_data$사고건수)
qqnorm(t_data$사고건수) #정규분포의 QQ plot을 그리는 함수
qqline(t_data$사고건수,col='blue')

x <- subset(t_data, t_data$사고건수 <=350)  #사고건수가 350개 이하인 데이터만 추출하여 x 변수 저장
x <- subset(x, x$경상자수>=50 & x$경상자수<=300) # x변수에서 경상자수 50~300명만 추출
x <- subset(x, x$부상신고자수 <=40)   # x변수에서 부상신고자수 40명이하만 추출
dim(x) #45개의 데이터와 9개의 변수 확인

par(mfrow=c(2,2))
hist(x$사고건수)
qqnorm(x$사고건수) 
qqline(x$사고건수,col='blue')
hist(x$경상자수)
qqnorm(x$경상자수)
qqline(x$경상자수,col='blue')
hist(x$부상신고자수)
qqnorm(x$부상신고자수)
qqline(x$부상신고자수,col='blue')
hist(x$중상자수)
qqnorm(x$중상자수)
qqline(x$중상자수,col='blue')

shapiro.test(x$사고건수)
shapiro.test(x$경상자수)
shapiro.test(x$부상신고자수)
shapiro.test(x$중상자수)
shapiro.test(x$사망자수)


## (16) 단일 표본평균 차이 검정 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
t.test(x$사고건수, mu=200, alternative="two.sided", conf.level=0.95)
t.test(x$사고건수, mu=200, alternative="greater", conf.level=0.95)
t.test(x$사고건수, mu=200, alternative="less", conf.level=0.95)


## (17) 두 집단 독립표본 – 동질성 검정
x <- c(12,14,10,14,16,17,22,16,13,14,12,12,11,15,16,18,22,15,8,17,22,15,19,27) #스마트폰 갯수
g <- c(1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2)  # 스마트폰 판매지역
s_data <- data.frame(x,g)
a <- subset(s_data, g==1)  # 스마트폰 판매지역 1인 데이터만 a 변수에 저장
b <- subset(s_data, g==2)  # 스마트폰 판매지역 2인 데이터만 b 변수에 저장
mean(a$x)
mean(b$x)  
shapiro.test(a$x)
shapiro.test(b$x)
var.test(a$x,b$x)

## (18) 두 집단 독립표본 – 표본평균 차이 검정
t.test(x~g, var.equal=TRUE, alternative="two.sided", conf.level=0.95, data=s_data)
#t.test(a$x,b$x, var.equal=TRUE, conf.level=0.95, data=s_data) #동일 결과 

## (19) 두 집단 독립표본 – 동질성 검정(등분산 미가정)
x <- c(3,4,12,20,16,27,10,12,13,4,2,12,11,15,16,18,12,15,18,17,22,15,24,17) # 스마트폰 갯수
g <- c(1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2) #스마트폰 판매지역
s_data <- data.frame(x,g)
a <- subset(s_data, g==1)
b <- subset(s_data, g==2)
mean(a$x)
mean(b$x)
shapiro.test(a$x)
shapiro.test(b$x)
var.test(a$x,b$x)  #var.test(x~g, data=s_data)는 var.test(a$x,b$x)와 동일

## (20) 두 집단 독립표본 –표본평균 차이 검정
t.test(x~g, var.equal=FALSE, alternative="two.sided", conf.level=0.95, data=s_data)


## (21) 두 집단 독립표본 – 정규성 검정 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
head(t_data)
t1 <- subset(t_data, 사고유형대분류=="차대사람" & 사고유형중분류=="보도통행중")
t2 <- subset(t_data, 사고유형대분류=="차대사람" & 사고유형중분류=="차도통행중")

t1_d <- t1$부상신고자수
t2_d <- t2$부상신고자수
shapiro.test(t1_d)
shapiro.test(t2_d)

## (22) 두 집단 독립표본 – 동질성 검정(등분산 가정) 및 표본 평균차이 검정 - 월별 교통사고 통계(2018)
var.test(t1_d,t2_d)
t.test(t1_d,t2_d, var.equal=TRUE, alternative="two.sided", conf.level=0.95)

## (23) 두 집단 독립표본 – 동질성 검정(등분산 가정) 및 표본 평균차이 검정 - 월별 교통사고 통계(2018)
t3_d <- t1$사망자수
t4_d <- t2$사망자수
shapiro.test(t3_d)
shapiro.test(t4_d)
var.test(t3_d,t4_d) 
t.test(t3_d,t4_d, var.equal=FALSE, alternative="two.sided", conf.level=0.95)


## (24) 두 집단 대응표본 – 정규성 검정, 등분산 검정 및 대응표본 검정 1
a <- c(62,72,54,83,79,74,73,72,71,70,69,68,82,94,45,46)  #동영상 청취 이전 사전테스트 점수
b <- c(70,80,56,85,88,83,76,85,76,77,82,62,75,94,65,70)  #동영상 청취 이후 마무리 테스트 점수
shapiro.test(a)
shapiro.test(b)
var.test(a,b, paired=TRUE)
mean(a)
mean(b)
t.test(a,b, paired=TRUE, alternative = "two.sided", conf.int=TRUE, conf.level=0.95)
t.test(a,b, paired=TRUE, alternative = "less", conf.int=TRUE, conf.level=0.95)

## (25) 두 집단 대응표본 – 정규성과 등분산 검정 2
a <- c(54,56,50,52,55,52,56,53,53,60)
b <- c(60,59,57,56,56,58,62,55,54,64)
shapiro.test(a)
shapiro.test(b)
mean(a);mean(b)
var.test(a,b, paired=TRUE)
t.test(a,b, paired=TRUE, alternative = "two.sided", conf.int=TRUE, conf.level=0.95)

## (26) 세 집단 분석(분산분석) 1 - 정규성 검정 (스마트폰 지역별 판매갯수)
x <- c(3,12,24,16,27,10,12,17,10,14,12,15,20,10,20,11,15,18,12,25,18,17,22,17,19,
                    9,17,15,17,9,10,26,23,40,20,25,18,15,19,20,17,18,15,25,30) # 스마트폰 판매갯수
g <- c(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3) 
# 판매지역
d <- data.frame(판매갯수=x,판매지역=g)
table(d$판매지역)

a_group <- as.factor(d$판매지역)
d1 <- subset(d, 판매지역==1)
d2 <- subset(d, 판매지역==2)
d3 <- subset(d, 판매지역==3)
t1 <- d1$판매갯수 
t2 <- d2$판매갯수
t3 <- d3$판매갯수
shapiro.test(t1)
shapiro.test(t2)
shapiro.test(t3)

## (27) 세 집단 분석(분산분석) 2 – 세 집단 이상의 분산 동질성 검정 (스마트폰 지역별 판매갯수)
boxplot(data=d, 판매갯수~판매지역, col="yellow")
library(stats)
bartlett.test(판매갯수~판매지역, data=d)  #세 집단 간 동질성 검정 수행

## (28) 세 집단 분석(분산분석) 3 – 세 집단 이상의 평균 검정 (스마트폰 지역별 판매갯수)
result <- aov(판매갯수~a_group, data=d)
summary(result)   # 세집단 평균차이 검정
mean(t1);mean(t2);mean(t3)

## (29) 세 집단 분석(분산분석) 4 – 세 집단 이상의 사후검정 (스마트폰 지역별 판매갯수)
install.packages("DescTools")  #사후검정을 위한 별도 패키지 설치
library("DescTools")
PostHocTest(result, method='lsd')  #DescTools 패키지에 포함된 사후검정 함수
plot(PostHocTest(result, method='lsd'))

## (30) 세 집단 분석(분산분석) 1 - 정규성 검정 (사고유형별 부상신고자수)
setwd("C:/Data Analysis/r_exam")
t <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
t1 <- subset(t, 사고유형대분류=="차대사람" & 사고유형중분류=="보도통행중")
t2 <- subset(t, 사고유형대분류=="차대사람" & 사고유형중분류=="차도통행중")
t3 <- subset(t, 사고유형대분류=="차대사람" & 사고유형중분류=="길가장자리구역통행중")
tt <- rbind(t1,t2,t3) # 세 개의 집단을 하나의 변수로 통합하여 저장 

t1_d <- t1$부상신고자수  # 차대사람 사고중 보도통행중에 일어난 사고
t2_d <- t2$부상신고자수  # 차대사람 사고중 차도통행중에 일어난 사고
t3_d <- t3$부상신고자수  # 차대사람 사고중 길가장자리구역통행중에 일어난 사고

shapiro.test(t1_d)
shapiro.test(t2_d)
shapiro.test(t3_d)

## (31) 세 집단 분석(분산분석) 2 – 등분산 검정 및 분산분석 검정
a_group <- as.factor(tt$사고유형)
boxplot(data=tt, 부상신고자수~a_group, col="yellow")
bartlett.test(부상신고자수~a_group, data=tt)
result <- aov(부상신고자수~a_group, data=tt)
summary(result)
mean(t1_d);mean(t2_d);mean(t3_d)

## (32) 세 집단 분석(분산분석) 3 – 사후검정
#install.packages("DescTools")
#library("DescTools")
PostHocTest(result, method='hsd')  #DescTools 패키지에 포함된 사후검정 함수
plot(PostHocTest(result, method='hsd'))


## (33) 교차분석과 카이제곱 분석 1
setwd("C:/Data Analysis/r_exam/") 
customer <- read.csv("한국소비자원 소비자 피해구제 정보_20210413.csv",header = TRUE)
head(customer)

#일원 카이제곱 검정
x <- customer$판매유형
table(x)
c_name <- c("TV홈쇼핑","국내온라인거래","국제온라인거래","기타","기타통신판매",
            "노상판매","다단계판매","모바일거래","방문판매", "소셜커머스(쇼핑)",
            "일반판매","전화권유판매")
c_count <- c(95,2025,57,969,568,12,8,355,585,359,3651,1130)
c_sum <- data.frame(c_name,c_count)
chisq.test(c_sum$c_count)


#이원 카이제곱 검정
y <- customer$성별
result <- data.frame(판매유형_민원=x, 성별=y)
dim(result)

table(result)

install.packages("gmodels") #교차 분할표 작성을 도와주는 패키지 설치
library(gmodels)
CrossTable(x=customer$판매유형,y=customer$성별, chisq=TRUE)


## (34) 교차분석과 카이제곱 분석 2
setwd("C:/Data Analysis/r_exam/") 
b_data <- read.csv("20210306_롯데야구기록.csv",header = TRUE)
head(b_data)

#일원 카이제곱 검정
table(b_data$홈런)
h_name <- c("우중홈","우홈","좌중홈","좌홈","중홈")
h_count <- c(4,10,11,29,8)
home <- data.frame(h_name,h_count)
chisq.test(home$h_count)


#이원 카이제곱 검정
x <- b_data$상대팀
y <- b_data$홈런
result <- data.frame(상대팀=x, 홈런_유형=y)
dim(result)
table(result)

install.packages("gmodels") #교차 분할표 작성을 도와주는 패키지 설치
library(gmodels)
CrossTable(x=b_data$상대팀,y=b_data$홈런, chisq=TRUE)



##############################################################
##                [7장] 상관분석과 회귀분석                 ##
##############################################################


## (1) 상관관계 분석 1 (서울특별시_강남구_불법주정차단속현황)
g_data <- read.csv("서울특별시_강남구_불법주정차단속현황_20210208.csv", header=TRUE)
gc_data <- subset(g_data, 부과건수<=15000)
gc_data <- gc_data[,3:5]
head(gc_data, 3)
cor(gc_data$부과건수,gc_data$단속원금.원., method="pearson")
cor(gc_data$부과건수,gc_data$견인건수, method="pearson")
cor(gc_data, method="pearson")

## (2) 상관관계 분석 2 (서울특별시_강남구_불법주정차단속현황) 
cor.test(gc_data$부과건수,gc_data$단속원금.원., method="pearson", alternative="two.sided")
cor.test(gc_data$부과건수,gc_data$견인건수, method="pearson", alternative="two.sided")


## (3) 상관관계 분석 – 시각화 1 (서울특별시_강남구_불법주정차단속현황)
install.packages("corrgram")
library(corrgram)
corrgram(gc_data)
corrgram(gc_data,upper.panel = panel.conf)

## (4) 상관관계 분석 – 시각화 2 (서울특별시_강남구_불법주정차단속현황)
install.packages("PerformanceAnalytics")
library(PerformanceAnalytics)
chart.Correlation(gc_data, method="pearson")

install.packages("corrplot")
library(corrplot)
cr <- cor(gc_data, method="pearson")
corrplot(cr, method="pie", type="full", tl.srt=20)

## (5) 상관관계 분석 - (도로교통공단_사고유형별 월별 교통사고 통계(2018))
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
t1 <- subset(t_data, 사고유형대분류=="차대사람" & 사고유형중분류=="횡단중")
t1 <- t1[,5:9] #사고건수, 사망자수, 중상자수, 경상자수, 부상신고자수 칼럼만 추출
head(t1, 3)

cor(t1$사고건수,t1$중상자수, method="pearson")
cor(t1, method="pearson")
cor.test(t1$사고건수, t1$중상자수)

install.packages("corrgram")
library(corrgram)
corrgram(t1)
corrgram(t1,lower.panel = panel.conf)

install.packages("PerformanceAnalytics")
library(PerformanceAnalytics)
chart.Correlation(t1)  

install.packages("corrplot")
library(corrplot)
cr <- cor(t1, method="pearson")
corrplot(cr, method="circle", tl.srt=20)

## (6) 상관관계 분석 (혁신제품 만족연구)
setwd("C:/Data Analysis/r_exam")
n_data <- read.csv("new_tech.csv", header=TRUE)
n_data2 <- n_data[,4:8] #4번째부터 8번째까지 혁신 칼럼만 추출
cor(n_data2$혁신_기술,n_data2$혁신_디자인, method="pearson")
cor(n_data2, method="pearson")
cor.test(n_data2$혁신_기술,n_data2$혁신_디자인)

install.packages("corrgram")
library(corrgram)
corrgram(n_data2)
corrgram(n_data2,lower.panel = panel.conf)

install.packages("PerformanceAnalytics")
library(PerformanceAnalytics)
chart.Correlation(n_data2)

install.packages("corrplot")
library(corrplot)
cr <- cor(n_data2, method="pearson")
corrplot(cr, method="number", tl.srt=40)


## (7) 단순회귀 분석 1
x <- c(6,8,3,4,3,3,7,6,5,6,4,5,4,6,9,12,12) #광고횟수
y <- c(12,14,10,11,14,10,16,18,16,22,22,15,9,12,27,29,25) #스마트폰 판매갯수
df <- data.frame(x,y)
colnames(df) <- c("광고횟수","스마트폰 판매갯수") 
head(df)

result <- lm(formula=y~x, data=df)
print(result)   #절편(5.607)과 기울기(1.745)

yy <- 6.307+(1.697*6)  #x값이 6으로 광고횟수를 6번 진행하게 된다는 가정
yy

summary(result)

plot(formula=y~x, data=df)  #선형 회귀분석 모델 시각화
abline(result, col='red')  

## (8) 단순 회귀분석 1 - (도로교통공단_사고유형별 월별 교통사고 통계(2018))
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
str(t_data)
t_data2 <- subset(t_data, t_data$사고유형=="횡단중")
head(t_data2)
result <- lm(formula=중상자수~사고건수, data=t_data2)
summary(result) 
plot(formula=중상자수~사고건수, data=t_data2)  #선형 회귀분석 모델 시각화
abline(result, col='red')  

## (9) 다중회귀분석 1 - (도로교통공단_사고유형별 월별 교통사고 통계(2018))
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)
t_data2 <- subset(t_data, t_data$사고유형=="횡단중")
str(t_data2)
result <- lm(formula = 사고건수 ~ 부상신고자수+경상자수+중상자수+사망자수, data=t_data2)
anova(result)
coef(result)
summary(result)
confint.default(result, level=0.95) 

install.packages("arm")
library(arm)
coefplot(result)

install.packages("car")
library(car)
vif(result)
sqrt(vif(result))>2
durbinWatsonTest(result)

par(mfrow = c(2, 3))
plot(result, 1:6)

shapiro.test(result$residuals)  
ncvTest(result)

install.packages("gvlma")
library(gvlma)
gvmodel <- gvlma(result)  
summary(gvmodel)

## (10) 다중회귀분석 - (혁신제품 만족연구)
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("new_tech.csv", header=TRUE)
t_data <- t_data[order(runif(nrow(t_data))), ]
str(t_data)
result <- lm(formula = 만족도 ~ 혁신_실용성+편의성_AS서비스+편의성_사용자+편의성_인터페이스, 
                           data=t_data)
anova(result)

#install.packages("gvlma")
library(gvlma)
gvmodel <- gvlma(result)  
summary(gvmodel)
confint.default(result, level=0.95)

#install.packages("car")
library(car)
vif(result)
sqrt(vif(result))>2
durbinWatsonTest(result) 

par(mfrow = c(2, 3))
plot(result, 1:6)

shapiro.test(result$residuals)
ncvTest(result)


##############################################################
##  [8장] 빅데이터 분석 및 시각화 : 지도학습과 분류분석     ##
##############################################################

## (1) 로지스틱 회귀분석 1 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header=TRUE)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자<=30,0,1))
head(t_data,4)

library(caret)
set.seed(213)
intrain <- createDataPartition(y=t_data$사망자범주, p=0.7, list=FALSE)
head(intrain,5)

train <- t_data[intrain, ] #훈련용 데이터
test <- t_data[-intrain, ] #검증용 데이터
nrow(train) ; nrow(test)

result <- glm(사망자범주~ 중상자수+경상자수+부상신고자수, data=train, family="binomial")
print(result) #로지스틱 회귀분석은 일반화 선형 모형이기 때문에 glm() 명령어로 실행
summary(result)

install.packages("ResourceSelection")
library(ResourceSelection)
hoslem.test(result$y, fitted(result))

install.packages("rms")
library(rms)
lrm(사망자범주~ 중상자수+경상자수+부상신고자수, data=train)

Log_odds = predict(result, test, type="link")
print(Log_odds)

test_probability = predict(result, test, type = 'response')
print(test_probability)

test_predict = ifelse(test_probability > 0.5 , 1, 0)
test_predict = as.vector(test_predict)
print(test_predict)

confusionMatrix(table(test$사망자범주,test_predict))

install.packages("pROC")
library(pROC)
ROC = roc(test$사망자범주,test_predict)

plot.roc(ROC, col="royalblue", print.auc=TRUE,max.auc.polygon=TRUE, print.thres=TRUE, 
                   print.thres.pch=19, print.thres.col = "red", auc.polygon=TRUE, 
                   auc.polygon.col="#D1F2EB")

train_probability <- predict(result, train, type="response")
train_predict <-  ifelse(train_probability > 0.5 , 1 , 0)
train_predict  <- as.vector(train_predict)
table(train_predict , train$사망자범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[11] <- "비교결과"
colnames(test_combine)[11] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com <- t_combine %>% filter(사망자범주 != 비교결과)
tail(t_com)


## (2) 로지스틱 회귀분석 1 – 혁신제품 만족연구(만족도 범주)
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("new_tech.csv", header=TRUE)

library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도<3,0,1))
head(t_data,4)

library(caret)
set.seed(2097)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

result <- glm(만족도범주~혁신_기술+혁신_품질+혁신_디자인+혁신_소프트웨어, 
                                     data=train, family="binomial")
summary(result)

#install.packages("ResourceSelection")
library(ResourceSelection)
hoslem.test(result$y, fitted(result))

library(rms)
lrm(만족도범주~혁신_기술+혁신_품질+혁신_디자인+혁신_소프트웨어, data=train)

Log_odds = predict(result, test)
print(Log_odds)

test_probability = predict(result, test, type = 'response')
print(test_probability)

test_predict = ifelse(test_probability > 0.5 , 1 , 0)
test_predict = as.vector(test_predict)
confusionMatrix(table(test$만족도범주,test_predict))

#install.packages("pROC")
library(pROC)
ROC = roc(test$만족도범주,test_predict)

plot.roc(ROC, col="royalblue", print.auc=TRUE,max.auc.polygon=TRUE, print.thres=TRUE, 
                    print.thres.pch=19, print.thres.col = "red", auc.polygon=TRUE, 
                    auc.polygon.col="#D1F2EB")

train_probability <- predict(result, train, type="response")
train_predict <-  ifelse(train_probability > 0.5 , 1 , 0)
train_predict  <- as.vector(train_predict)
table(train_predict , train$만족도범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[15] <- "비교결과"
colnames(test_combine)[15] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com <- t_combine %>% filter(만족도범주 != 비교결과)
tail(t_com)

## (3) tree 패키지 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("tree")
library(tree)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)
str(t_data)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, "없음", 
                                                  ifelse(t_data$사망자수 <= 30 , "적음","많음")))
head(t_data,4)   

t_data$사망자범주 <- as.factor(t_data$사망자범주)　　

#install.packages("caret") 
library(caret)
set.seed(3003)
intrain <- createDataPartition(y=t_data$사망자범주, p=0.7, list=FALSE)
head(intrain,5)     

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

t_analysis <- 사망자범주~ 중상자수 + 경상자수 + 부상신고자수
tree_train <- tree(t_analysis, data=train)
print(tree_train)

plot(tree_train)
text(tree_train)

cv_train <- cv.tree(tree_train, FUN=prune.misclass) # 가지치기(PRUNING)를 위한 편차 확인
plot(cv_train)

prune.trees <- prune.misclass(tree_train, best=7)
prune.trees

plot(prune.trees)
text(prune.trees)

test_predict <- predict(prune.trees, test, type='class')
result <- confusionMatrix(test_predict,test$사망자범주)
print(result)

train_predict <- predict(prune.trees, train, type="class")
table(train_predict, train$사망자범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[11] <- "의사결정트리"
colnames(test_combine)[11] <- "의사결정트리"
t_combine <- rbind(train_combine, test_combine)

t_combine %>% filter(사망자범주 != 의사결정트리)


## (4) party 패키지 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("party")
library(party)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, "없음", 
                                               ifelse(t_data$사망자수 <= 30 , "적음","많음")))
head(t_data,4) 

t_data$사망자범주 <- as.factor(t_data$사망자범주)　　
set.seed(1333)
intrain=sample(1:2, nrow(t_data), replace=TRUE, prob=c(0.6,0.4)) 
print(intrain)

#벡터(vector) 혹은 데이터 프레임(data frame)에서 지정된 크기만큼 데이터를 무작위로 추출
train <- t_data[intrain==1, ]
test <- t_data[intrain==2, ]
nrow(train) ; nrow(test)

t_analysis <- 사망자범주~ 중상자수 + 경상자수 + 부상신고자수   
ctree_train <- ctree(t_analysis, data=train)
print(ctree_train)
plot(ctree_train)
plot(ctree_train, type='simple')

library(caret)
test_predict <- predict(ctree_train, test)
result <- confusionMatrix(test_predict,test$사망자범주)
print(result)

train_predict <- predict(ctree_train, train)
table(train_predict, train$사망자범주)  

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[11] <- "의사결정트리"
colnames(test_combine)[11] <- "의사결정트리"
t_combine <- rbind(train_combine, test_combine)

t_combine %>% filter(사망자범주 != 의사결정트리)

## (5) rpart 패키지 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("rpart")
library(rpart)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)
str(t_data)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, "없음", 
                                                  ifelse(t_data$사망자수 <= 30 , "적음","많음")))
head(t_data,4)

t_data$사망자범주 <- as.factor(t_data$사망자범주)　　
set.seed(1117)
intrain=sample(1:2, nrow(t_data), replace=TRUE, prob=c(0.6,0.4)) 
#sample() 함수로 지정된 크기만큼 데이터를 무작위로 추출
print(intrain)

train=t_data[intrain==1,]  #학습데이터
test=t_data[intrain==2,]   #검정데이터
nrow(train) ; nrow(test) 

t_analysis <- 사망자범주~ 중상자수 + 경상자수 + 부상신고자수
rtree_train <- rpart(t_analysis, data=train)
print(rtree_train)

install.packages("rpart.plot")
library(rpart.plot)
rpart.plot(rtree_train)
rpart.plot(rtree_train, digits=2, fallen.leaves = FALSE, type=1, extra=101)

printcp(rtree_train) #기준이 되는 복잡도(Complexity parameter)

pruned_train <- prune(rtree_train, cp = 0.064) #cp값으로 가지치기
rpart.plot(pruned_train)

library(caret)
test_predict <- predict(pruned_train, test, type="class")
result <- confusionMatrix(test_predict,test$사망자범주)
print(result)   

train_predict <- predict(pruned_train, train, type="class")
table(train_predict, train$사망자범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[11] <- "의사결정트리"
colnames(test_combine)[11] <- "의사결정트리"
t_combine <- rbind(train_combine, test_combine)      
t_combine %>% filter(사망자범주 != 의사결정트리) 

## (6) tree 패키지 1 – 혁신제품 만족연구
install.packages("tree")
library(tree)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("new_tech.csv", header = TRUE)
str(t_data)

library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, "불만족", 
                                                 ifelse(t_data$만족도 <= 3.8 , "보통","만족")))
head(t_data,4) 

t_data$만족도범주 <- as.factor(t_data$만족도범주)　　
#install.packages("caret") 
library(caret)
set.seed(100)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)    

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

t_analysis <- 만족도범주~ 혁신_기술 + 혁신_디자인 + 혁신_소프트웨어 + 혁신_품질
tree_train <- tree(t_analysis, data=train)
print(tree_train)

plot(tree_train)
text(tree_train)

cv_train <- cv.tree(tree_train, FUN=prune.misclass) # 가지치기(PRUNING)를 위한 편차 확인
plot(cv_train)

prune.trees <- prune.misclass(tree_train, best=6)
prune.trees

plot(prune.trees)
text(prune.trees) 

test_predict <- predict(prune.trees, test, type='class')
result <- confusionMatrix(test_predict,test$만족도범주)
print(result)

train_predict <- predict(prune.trees, train, type="class")
table(train_predict, train$만족도범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[15] <- "의사결정트리"
colnames(test_combine)[15] <- "의사결정트리"
t_combine <- rbind(train_combine, test_combine)

t_com2 <- t_combine %>% filter(만족도범주 != 의사결정트리)
tail(t_com2)


## (7) party 패키지 1 – 혁신제품 만족연구
install.packages("party")
library(party)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("new_tech.csv", header = TRUE)
library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, "불만족", 
                                         ifelse(t_data$만족도 <= 3.8 , "보통","만족")))
head(t_data,4) 

t_data$만족도범주 <- as.factor(t_data$만족도범주)　　
#install.packages("caret") 
library(caret)
set.seed(600)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)    

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

t_analysis <- 만족도범주~ 혁신_기술 + 혁신_디자인 + 혁신_소프트웨어 + 혁신_품질
tree_train <- ctree(t_analysis, data=train)
print(tree_train)
plot(tree_train)

# 예측 및 모델평가
test_predict <- predict(tree_train, test)
result <- confusionMatrix(test_predict,test$만족도범주)
print(result) 

train_predict <- predict(prune.trees, train, type="class")
table(train_predict, train$만족도범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[15] <- "의사결정트리"
colnames(test_combine)[15] <- "의사결정트리"
t_combine <- rbind(train_combine, test_combine)

t_com2 <- t_combine %>% filter(만족도범주 != 의사결정트리)
tail(t_com2)

t_data$만족도범주 <- as.factor(t_data$만족도범주)　　
#install.packages("caret") 
library(caret)
set.seed(7707)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)   

## (8) rpart 패키지 1 – 혁신제품 만족연구
install.packages("rpart")
library(rpart)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("new_tech.csv", header = TRUE)
library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, "불만족", 
                                                       ifelse(t_data$만족도 <= 3.8 , "보통","만족")))
head(t_data,4) 

t_data$만족도범주 <- as.factor(t_data$만족도범주)　　
#install.packages("caret") 
library(caret)
set.seed(7707)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5) 

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

t_analysis <- 만족도범주~ 혁신_기술 + 혁신_디자인 + 혁신_소프트웨어 + 혁신_품질
tree_train <- rpart(t_analysis, data=train)
print(tree_train)

train_predict <- predict(pruned_train, train, type="class")
table(train_predict, train$만족도범주) 
library(rpart.plot)
rpart.plot(tree_train)

printcp(tree_train) #기준이 되는 복잡도(Complexity parameter)
pruned_train <- prune(tree_train, cp = 0.050) 
rpart.plot(pruned_train)

test_predict <- predict(pruned_train, test, type="class")
result <- confusionMatrix(test_predict,test$만족도범주)
print(result) 

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[15] <- "의사결정트리"
colnames(test_combine)[15] <- "의사결정트리"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(만족도범주 != 의사결정트리)
tail(t_com2)


## (9) Bagging 1 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("adabag")
library(adabag)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)
str(t_data)
library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, "없음", 
                                              ifelse(t_data$사망자수 <= 30 , "적음","많음")))
head(t_data,4)   

t_data$사망자범주 <- as.factor(t_data$사망자범주)
t_data <- t_data[-c(1:6)]
head(t_data,4)  

set.seed(2001)
intrain=sample(1:2, nrow(t_data), replace=TRUE, prob=c(0.6,0.4))
print(intrain)

train=t_data[intrain==1,]
test=t_data[intrain==2,]

library(rpart)
bagging_data <- bagging(사망자범주~ 중상자수+경상자수+부상신고자수,data=train, mfinal=3, 
                               control=rpart.control(maxdepth=3, minsplit=3)) #최대깊이 5, 최소노드 3

print(bagging_data$trees)

library(rpart.plot)
rpart.plot(bagging_data$trees[[1]])

test_predict <- predict(bagging_data,test)
test_factor_pred <- as.factor(test_predict$class)
result <- confusionMatrix(test_factor_pred,test$사망자범주)
print(result) 
bagging_data$importance

train_predict <- predict(bagging_data, train)
train_factor_pred <- as.factor(train_predict$class)
table(train_factor_pred, train$사망자범주)

train_combine <- data.frame(train, train_factor_pred)
test_combine <- data.frame(test, test_factor_pred)   
colnames(train_combine)[5] <- "비교결과"
colnames(test_combine)[5] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(사망자범주 != 비교결과)
tail(t_com2)

# (10) Boosting 1 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("xgboost")
library(xgboost)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)
library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, 0, 
                                        ifelse(t_data$사망자수 <= 30 , 1, 2)))
#Boosting에서는 범주의 값을 숫자로 지정해야 함
head(t_data,4)   

t_data <- t_data[-c(1:6)]  #Boosting 계산에서 사용하지 않는 칼럼을 제거하지 않으면 오류발생
# Boosting 계산에서 중상자수, 경상자수, 부상신고자수, 사망자범주만 사용
head(t_data,4)

set.seed(1005)
intrain=sample(1:2, nrow(t_data), replace=TRUE, prob=c(0.6,0.4))
print(intrain)

train=t_data[intrain==1,]
test=t_data[intrain==2,]
# Boosting 계산을 위해서 데이터 타입 구조를 matrix 구조로 변환하고, 
# 4번째 칼럼인 사망자범주 변수는 계산에 boosting 설명변수에 포함되지 않아야 하므로 제외함
train_mat <- as.matrix(train[-4])
test_mat <- as.matrix(test[-4])
dim(train_mat) ; head(train_mat,5)

#사망자범주 칼럼을 별도의 변수로 저장
train_lab <- train$사망자범주
test_lab <- test$사망자범주
# 훈련용 데이터가 xgboost() 함수에서 계산이 될 수 있으려면 xgb.DMatrix() 함수를 이용하여
# 별도의 매트릭스 구조로 재저장해야 함
dtrain <- xgb.DMatrix(data=train_mat, label=train_lab)
xgb_model <- xgboost(data=dtrain, max_depth=4, eta=1, verbose=0, nrounds=150, 
                                              objective="multi:softmax", num_class=3)
print(xgb_model)

test_predict <- predict(xgb_model, test_mat, type="class")
test_factor_pred <- as.factor(test_predict)
factor_사망자범주 <- as.factor(test$사망자범주)
result <- confusionMatrix(test_factor_pred,factor_사망자범주)
print(result)

train_predict <- predict(xgb_model, train_mat, type="class")
train_factor_pred <- as.factor(train_predict)
table(train_factor_pred, train_lab)

train_combine <- data.frame(train, train_factor_pred)
test_combine <- data.frame(test, test_factor_pred)   
colnames(train_combine)[5] <- "비교결과"
colnames(test_combine)[5] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(사망자범주 != 비교결과)
tail(t_com2)

importance_matrix <- xgb.importance(colnames(train_mat), model=xgb_model)
print(importance_matrix)
xgb.plot.importance(importance_matrix)


# (11) Random Forest 1 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("randomForest")
library(randomForest)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)
str(t_data)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, "없음", 
                                          ifelse(t_data$사망자수 <= 30 , "적음","많음")))
head(t_data,4)   

t_data$사망자범주 <- as.factor(t_data$사망자범주)　　

#install.packages("caret") 
library(caret)
set.seed(5000)
intrain <- createDataPartition(y=t_data$사망자범주, p=0.7, list=FALSE)
head(intrain,5) 

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

t_data$사망자범주 <- as.factor(t_data$사망자범주)　　
model1 = randomForest(사망자범주~ 중상자수+경상자수+부상신고자수, data=train)
print(model1)
plot(model1)
legend("topright",colnames(model1$err.rate),col=1:4,cex=0.8,fill=1:4)

model2 = randomForest(사망자범주~ 중상자수+경상자수+부상신고자수, ntree=500, mtry=3, 
                                                   importance=TRUE, na.action=na.omit, data=train)
print(model2)

plot(model2)
legend("topright",colnames(model1$err.rate),col=1:4,cex=0.8,fill=1:4)

# 예측 및 모델평가
test_predict <- predict(model2, test)
result <- confusionMatrix(test_predict,test$사망자범주)
print(result) 

train_predict <- predict(model2)
table(train_predict, train$사망자범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[11] <- "비교결과"
colnames(test_combine)[11] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(사망자범주 != 비교결과)
tail(t_com2)

importance(model2)


# (12) Bagging 1 - 혁신제품 만족연구
install.packages("adabag")
library(adabag)
t_data <- read.csv("new_tech.csv", header = TRUE)
str(t_data)

library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, "불만족", 
                                                  ifelse(t_data$만족도 <= 3.8 , "보통","만족")))
t_data$만족도범주 <- as.factor(t_data$만족도범주)
head(t_data,4)  

intrain=sample(1:2, nrow(t_data), replace=TRUE, prob=c(0.6,0.4))
train=t_data[intrain==1,]
test=t_data[intrain==2,]
nrow(train) ; nrow(test)

library(rpart)
bagging_data <- bagging(만족도범주~ 혁신_기술+혁신_디자인+혁신_소프트웨어+
                                           혁신_품질, data=train,mfinal=3, control=rpart.control(maxdepth=3, minsplit=3)) 
print(bagging_data$trees)

library(rpart.plot)
rpart.plot(bagging_data$trees[[1]])
rpart.plot(bagging_data$trees[[2]])
rpart.plot(bagging_data$trees[[3]])

test_predict <- predict(bagging_data,test)
test_factor_pred <- as.factor(test_predict$class)
result <- confusionMatrix(test_factor_pred,test$만족도범주)
print(result) 

bagging_data$importance

train_predict <- predict(bagging_data, train)
train_factor_pred <- as.factor(train_predict$class)
table(train_factor_pred, train$만족도범주)

train_combine <- data.frame(train, train_factor_pred)
test_combine <- data.frame(test, test_factor_pred)   
colnames(train_combine)[15] <- "비교결과"
colnames(test_combine)[15] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(만족도범주 != 비교결과)
tail(t_com2)

# (13) Boosting 1 - 혁신제품 만족연구
install.packages("xgboost")
library(xgboost)
t_data <- read.csv("new_tech.csv", header = TRUE)
library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, 0, 
                                                      ifelse(t_data$만족도 <= 3.8 , 1,2)))
head(t_data,4)

set.seed(2052)
intrain=sample(1:2, nrow(t_data), replace=TRUE, prob=c(0.6,0.4))
train=t_data[intrain==1,]
test=t_data[intrain==2,]
nrow(train) ; nrow(test)

train_adj <- train[-c(1:3,7,9:14)] #혁신_기술,혁신_디자인,혁신_소프트웨어,혁신_품질 칼럼만 저장
test_adj <- test[-c(1:3,7,9:14)]  #혁신_기술,혁신_디자인,혁신_소프트웨어,혁신_품질 칼럼만 저장
train_mat <- as.matrix(train_adj)
test_mat <- as.matrix(test_adj)
train_lab <- train$만족도범주
test_lab <- test$만족도범주

dtrain <- xgb.DMatrix(data=train_mat, label=train_lab)
xgb_model <- xgboost(data=dtrain, max_depth=3, eta=1, verbose=0, nrounds=2, nthread=2,
                     objective="multi:softmax", num_class=3)
print(xgb_model)

test_predict <- predict(xgb_model, test_mat, type="class")
test_factor_pred <- as.factor(test_predict)
factor_만족도범주 <- as.factor(test$만족도범주)
result <- confusionMatrix(test_factor_pred,factor_만족도범주)
print(result)

train_predict <- predict(xgb_model, train_mat, type="class")
train_factor_pred <- as.factor(train_predict)
table(train_factor_pred, train_lab)

train_combine <- data.frame(train, train_factor_pred)
test_combine <- data.frame(test, test_factor_pred)   
colnames(train_combine)[15] <- "비교결과"
colnames(test_combine)[15] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(만족도범주 != 비교결과)
tail(t_com2)

importance_matrix <- xgb.importance(colnames(train_mat), model=xgb_model)
importance_matrix

# (14) Random Forest 1 - 혁신제품 만족연구
install.packages("randomForest")
library(randomForest)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("new_tech.csv", header = TRUE)

library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, "불만족", 
                                             ifelse(t_data$만족도 <= 3.8 , "보통","만족")))
t_data$만족도범주 <- as.factor(t_data$만족도범주)　　
head(t_data,4) 

# install.packages("caret") 
library(caret)
set.seed(5000)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)   

train <- t_data[intrain, ]   # 199개 훈련 데이터
test <- t_data[-intrain, ]  # 84개 검증 데이터
nrow(train) ; nrow(test)

model = randomForest(만족도범주~ 혁신_기술+혁신_디자인+혁신_소프트웨어+혁신_품질, data=train, 
                                           ntree=500, mtry=3, importance=TRUE, na.action=na.omit)
print(model)

plot(model)
legend("topright",colnames(model$err.rate),col=1:4,cex=0.8,fill=1:4)

test_predict <- predict(model, test)
result <- confusionMatrix(test_predict,test$만족도범주)
print(result) 

train_predict <- predict(model)
table(train_predict, train$만족도범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[15] <- "비교결과"
colnames(test_combine)[15] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(만족도범주 != 비교결과)
tail(t_com2)

importance(model)
varImpPlot(model)


## (15) 인공신경망 1 - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("nnet")
library(nnet)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, "없음", 
                                                      ifelse(t_data$사망자수 <= 30 , "적음", "많음")))
head(t_data,4)

t_data$사망자범주 <- as.factor(t_data$사망자범주)　

# install.packages("caret") 
library(caret)
set.seed(9025)
intrain <- createDataPartition(y=t_data$사망자범주, p=0.7, list=FALSE)
head(intrain,5)  

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

model1 = nnet(사망자범주~ 중상자수+경상자수+부상신고자수, size=1, data=train)
print(model1)
summary(model1)

library("devtools")
source_url('https://gist.githubusercontent.com/fawda123/7471137/raw/466c1474d0a505ff044412703516c34f1a4684a5/nnet_plot_update.r')
library("reshape2")
plot.nnet(model1)

model2 = nnet(사망자범주~ 중상자수+경상자수+부상신고자수, size=3, data=train)
print(model2)
summary(model2)
plot.nnet(model2)

test_predict_M1 <- predict(model1, test, type="class")
test_predict_M1 <- as.factor(test_predict_M1)
result <- confusionMatrix(test_predict_M1,test$사망자범주)
print(result)

train_predict_M1 <- predict(model1, train, type="class")
train_factor_pred_M1 <- as.factor(train_predict_M1)
table(train_factor_pred_M1, train$사망자범주)

train_combine_M1 <- data.frame(train, train_predict_M1)
test_combine_M1 <- data.frame(test, test_predict_M1)   
colnames(train_combine_M1)[11] <- "비교결과"
colnames(test_combine_M1)[11] <- "비교결과"
t_combine_M1 <- rbind(train_combine_M1, test_combine_M1)
t_com2_M1 <- t_combine_M1 %>% filter(사망자범주 != 비교결과)
tail(t_com2_M1)


test_predict_M2 <- predict(model2, test, type="class")
test_predict_M2 <- as.factor(test_predict_M2)
result <- confusionMatrix(test_predict_M2,test$사망자범주)
print(result)

train_predict_M2 <- predict(model2, train, type="class")
train_factor_pred_M2 <- as.factor(train_predict_M2)
table(train_factor_pred_M2, train$사망자범주)

train_combine_M2 <- data.frame(train, train_predict_M2)
test_combine_M2 <- data.frame(test, test_predict_M2)   
colnames(train_combine_M2)[11] <- "비교결과"
colnames(test_combine_M2)[11] <- "비교결과"
t_combine_M2 <- rbind(train_combine_M2, test_combine_M2)
t_com2_M2 <- t_combine_M2 %>% filter(사망자범주 != 비교결과)
tail(t_com2_M2)

## (16) 인공신경망 1 (neuralnet) - 도로교통공단_사고유형별 월별 교통사고 통계(2018)
install.packages("neuralnet")
library(neuralnet)

setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2018).csv", header = TRUE)

library(dplyr)
t_data <- t_data %>% mutate("사망자범주" = ifelse(t_data$사망자수 == 0, 1, 
                                                         ifelse(t_data$사망자수 <= 30 , 2, 3)))

t_data <- t_data %>% mutate("없음" = ifelse(t_data$사망자범주==1,1,0))
t_data <- t_data %>% mutate("적음" = ifelse(t_data$사망자범주==2,1,0))
t_data <- t_data %>% mutate("많음" = ifelse(t_data$사망자범주==3,1,0)) 

t_data <- t_data[-c(1:4)]  #인공신경망에서 문자데이터가 있으면 계산오류가 발생

head(t_data,4) 

# install.packages("caret") 
library(caret)
set.seed(5001)
intrain <- createDataPartition(y=t_data$사망자범주, p=0.7, list=FALSE)
head(intrain,5)  

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)


normal <- function(x) { return((x-min(x))/(max(x)-min(x))) }
train_nor <- as.data.frame(lapply(train,normal))
test_nor <- as.data.frame(lapply(test,normal))
head(train_nor, 4)

model = neuralnet(없음+적음+많음~ 중상자수+경상자수+부상신고자수, data=train_nor,
                       act.fct = "logistic", linear.output = TRUE, likelihood = TRUE, hidden=c(4,4), threshold=0.01)
print(model)

plot(model)
print(model$result.matrix)
head(model$generalized.weights[[1]])

par(mfrow=c(2,2))
gwplot(model, selected.covariate = "중상자수",selected.response = "없음", min=-20,max=20)
gwplot(model, selected.covariate = "경상자수",selected.response = "없음", min=-20,max=20)
gwplot(model, selected.covariate = "부상신고자수",selected.response = "없음", min=-20,max=20)

par(mfrow=c(2,2))
gwplot(model, selected.covariate = "중상자수",selected.response = "적음", min=-20,max=20)
gwplot(model, selected.covariate = "경상자수",selected.response = "적음", min=-20,max=20)
gwplot(model, selected.covariate = "부상신고자수",selected.response = "적음", min=-20,max=20)


par(mfrow=c(2,2))
gwplot(model, selected.covariate = "중상자수",selected.response = "많음", min=-20,max=20)
gwplot(model, selected.covariate = "경상자수",selected.response = "많음", min=-20,max=20)
gwplot(model, selected.covariate = "부상신고자수",selected.response = "많음", min=-20,max=20)


test_nor2 <- test_nor[c(3:5)] #중상자수, 경상자수, 부상신고자수 칼럼만 추출
test_predict<- neuralnet::compute(model,test_nor2)$net.result
test_prediction <-c(1,2,3)[apply(test_predict,1,which.max)]
predict.table<-table(test$사망자범주,test_prediction)
confusionMatrix(predict.table)

train_nor2 <- train_nor[c(3:5)] #중상자수, 경상자수, 부상신고자수 칼럼만 추출
train_predict <- neuralnet::compute(model,train_nor2)$net.result
train_prediction <- c(1,2,3)[apply(train_predict,1,which.max)]
table(train$사망자범주,train_prediction)

train_s <- apply(train_predict,1,which.max)
test_s <- apply(test_predict,1,which.max)
train_combine <- data.frame(train, train_s)
test_combine <- data.frame(test, test_s)   
colnames(train_combine)[10] <- "비교결과"
colnames(test_combine)[10] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(사망자범주 != 비교결과)
tail(t_com2)

cor(test_predict[,1], test_nor$없음); cor(test_predict[,2], test_nor$적음); 
cor(test_predict[,3], test_nor$많음)

## (17) 인공신경망 1 (nnet) - 혁신제품 만족연구
install.packages("nnet")
library(nnet)
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("new_tech.csv", header = TRUE)
str(t_data)

library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, 1, 
                                               +                         ifelse(t_data$만족도 <= 3.8 , 2,3)))
head(t_data,3) 
t_data$만족도범주 <- as.factor(t_data$만족도범주)

library(caret)
set.seed(7000)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)  

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

model = nnet(만족도범주~ 혁신_기술 + 혁신_디자인 + 혁신_소프트웨어 + 혁신_품질,  size=5, 
                                   decay = 0.0005, maxit = 1500, data=train)

print(model)
summary(model)
library("devtools")
source_url('https://gist.githubusercontent.com/fawda123/7471137/raw/466c1474d0a505ff044412703516c34f1a4684a5/nnet_plot_update.r')
library("reshape2")
plot.nnet(model)

test_predict <- predict(model, test, type="class")
test_predict <- as.factor(test_predict)
result <- confusionMatrix(test_predict,test$만족도범주)
print(result)

train_predict <- predict(model, train, type="class")
train_factor_pred <- as.factor(train_predict)
table(train_factor_pred, train$만족도범주)

train_combine <- data.frame(train, train_predict)
test_combine <- data.frame(test, test_predict)   
colnames(train_combine)[15] <- "비교결과"
colnames(test_combine)[15] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com <- t_combine %>% filter(만족도범주 != 비교결과)
tail(t_com)



## (18) 인공신경망 1 (neuralnet) - 혁신제품 만족연구
setwd("C:/Data Analysis/r_exam/")
t_data <- read.csv("new_tech.csv", header = TRUE)

library(dplyr)
t_data <- t_data %>% mutate("만족도범주" = ifelse(t_data$만족도 < 3, 1, 
                                             ifelse(t_data$만족도 <= 3.8 , 2,3)))

t_data <- t_data %>% mutate("불만족" = ifelse(t_data$만족도범주==1,1,0))
t_data <- t_data %>% mutate("보통" = ifelse(t_data$만족도범주==2,1,0))
t_data <- t_data %>% mutate("만족" = ifelse(t_data$만족도범주==3,1,0)) 
head(t_data,4) 


# install.packages("caret") 
library(caret)
set.seed(5001)
intrain <- createDataPartition(y=t_data$만족도범주, p=0.7, list=FALSE)
head(intrain,5)   

train <- t_data[intrain, ]
test <- t_data[-intrain, ]
nrow(train) ; nrow(test)

normal <- function(x) { return((x-min(x))/(max(x)-min(x))) }
train_nor <- as.data.frame(lapply(train,normal))
test_nor <- as.data.frame(lapply(test,normal))
head(train_nor, 4)

model = neuralnet(불만족+보통+만족~ 혁신_기술 + 혁신_디자인 + 혁신_소프트웨어 + 혁신_품질, 
                                    data=train_nor,act.fct = "logistic", linear.output = TRUE, likelihood = TRUE, 
                                    hidden=c(2,2), threshold=0.01)
plot(model)
print(model$result.matrix)
head(model$generalized.weights[[1]])

par(mfrow=c(2,2))
gwplot(model, selected.covariate = "혁신_기술",selected.response = "불만족", min=-30,max=20)
gwplot(model, selected.covariate = "혁신_디자인",selected.response = "불만족", min=-30,max=20)
gwplot(model, selected.covariate = "혁신_소프트웨어",selected.response = "불만족", min=-30,max=20)
gwplot(model, selected.covariate = "혁신_품질",selected.response = "불만족", min=-30,max=20)

par(mfrow=c(2,2))
gwplot(model, selected.covariate = "혁신_기술",selected.response = "보통", min=-30,max=30)
gwplot(model, selected.covariate = "혁신_디자인",selected.response = "보통", min=-30,max=30)
gwplot(model, selected.covariate = "혁신_소프트웨어",selected.response = "보통", min=-30,max=30)
gwplot(model, selected.covariate = "혁신_품질",selected.response = "보통", min=-30,max=30)

par(mfrow=c(2,2))
gwplot(model, selected.covariate = "혁신_기술",selected.response = "만족", min=-50,max=50)
gwplot(model, selected.covariate = "혁신_디자인",selected.response = "만족", min=-50,max=50)
gwplot(model, selected.covariate = "혁신_소프트웨어",selected.response = "만족", min=-50,max=50)
gwplot(model, selected.covariate = "혁신_품질",selected.response = "만족", min=-50,max=50)

test_nor2 <- test_nor[c(4:6,8)] #혁신기술,혁신디자인,혁신소프트웨어,혁신품질 칼럼만 추출
test_predict<- neuralnet::compute(model,test_nor2)$net.result
test_prediction <-c(1,2,3)[apply(test_predict,1,which.max)]
predict.table<-table(test$만족도범주,test_prediction)
confusionMatrix(predict.table)


train_nor2 <- train_nor[c(4:6,8)] #혁신기술,혁신디자인,혁신소프트웨어,혁신품질 칼럼만 추출
train_predict<- neuralnet::compute(model,train_nor2)$net.result
train_prediction <-c(1,2,3)[apply(train_predict,1,which.max)]
table(train$만족도범주,train_prediction)

train_s <- apply(train_predict,1,which.max)
test_s <- apply(test_predict,1,which.max)
train_combine <- data.frame(train, train_s)
test_combine <- data.frame(test, test_s)   
colnames(train_combine)[18] <- "비교결과"
colnames(test_combine)[18] <- "비교결과"
t_combine <- rbind(train_combine, test_combine)
t_com2 <- t_combine %>% filter(만족도범주 != 비교결과)
tail(t_com2)

cor(test_predict[,1], test_nor$불만족); cor(test_predict[,2], test_nor$보통); 
cor(test_predict[,3], test_nor$만족)


##############################################################
##  [9장] 빅데이터 분석 및 시각화 : 비지도학습과 분류분석   ##
##############################################################

## (1)  계층적 군집분석 - (음식점 군집분석)
a <- c(90,55,36,46,65,85)
b <- c(93,70,20,60,35,90)

data <- cbind(a,b)
colnames(data) <- c("식당맛집점수", "식당청결점수")
rownames(data) <- c("강릉찌개","수원갈비","한라식당","김천국밥","양양햄버거","제주식당")
print(data)

eu_dist <- round(dist(data, method = "euclidean"), digits=2) #유클리드안 거리행렬
print(eu_dist)

result1 <- hclust(eu_dist, method="single") #최단연결법
plot(result1, main="식당 선호집단분류-single방법:최단연결법")
rect.hclust(result1,k=3)

man_dist <- round(dist(data, method="manhattan"), digits=2) #맨하탄 거리행렬
print(man_dist)

result2 <- hclust(man_dist, method="single") #최단연결법
plot(result2, main="식당 선호집단분류-single방법:최단연결법")
rect.hclust(result2,k=3)

can_dist <- round(dist(data, method="canberra"), digits=2) #캔버라 거리행렬
print(can_dist)

result3 <- hclust(can_dist, method="single") #최단연결법
plot(result3, main="식당 선호집단분류-single방법:최단연결법")
rect.hclust(result3,k=3)

result4 <- hclust(dist(data, method="euclidean"), method="complete") #최장연결법
plot(result4, main="식당 선호집단분류-complete방법:최장연결법")
rect.hclust(result4,k=3) 

result5 <- hclust(dist(data, method="euclidean"), method="centroid") #중심연결법
plot(result5, main="식당 선호집단분류-centroid방법:중심연결법")
rect.hclust(result5,k=3) 

result6 <- hclust(dist(data, method="euclidean"), method="ward.D2") #와드연결법
plot(result6, main="식당 선호집단분류-ward방법:와드연결법")
rect.hclust(result6,k=3)

result7 <- hclust(dist(data, method="euclidean"), method="average") #평균연결법
plot(result7, main="식당 선호집단분류-average방법:평균연결법")
rect.hclust(result7,k=3)


## (2) 계층적 군집분석 - (국가철도공단 공항철도 역간거리)
setwd("C:/Data Analysis/r_exam")
data <- read.csv("국가철도공단_공항철도_역간거리_20201121.csv", header=TRUE)
print(data)

data2 <- data.frame(data[,4])
colnames(data2) <- "영업거리"
data_name <- data[,3]
rownames(data2) <- data_name
print(data2)

eu_dist <- round(dist(data2, method = "euclidean"), digits=2) #유클리드안 거리행렬
print(eu_dist)

result1 <- hclust(eu_dist, method="single") #최단연결법
plot(result1, main="공항철도 집단분류-single방법:최단연결법")
rect.hclust(result1,k=4)

result2 <- hclust(eu_dist, method="complete") #최장연결법
plot(result2, main="공항철도 집단분류-complete방법:최장연결법")
rect.hclust(result2,k=4)

result3 <- hclust(eu_dist, method="average") #평균연결법
plot(result3, main="공항철도 집단분류--average방법:평균연결법")
rect.hclust(result3,k=4) 

result4 <- hclust(eu_dist,method="centroid") #중심연결법
plot(result4, main="공항철도 집단분류-centroid방법:중심연결법")
rect.hclust(result4,k=4)

result5 <- hclust(eu_dist, method="ward.D2") #와드연결법
plot(result5, main="공항철도 집단분류-ward.D2방법:와드연결법")
rect.hclust(result5,k=4)

g_group <- cutree(result5, k=4)
print(g_group)

g_cluster <- cbind(data,g_group)
print(g_cluster)


## (3) 비계층적 군집분석 - (음식점 군집분석)
a <- c(90,55,36,46,65,85)
b <- c(93,70,20,60,35,90)

data <- cbind(a,b)
colnames(data) <- c("식당맛집점수", "식당청결점수")
rownames(data) <- c("강릉찌개","수원갈비","한라식당","김천국밥","양양햄버거","제주식당")
print(data) 

k_means <- kmeans(data,3)
k_means

k_means$cluster

k_group <- k_means$cluster
data <- cbind(data,k_group)
head(data)
plot(data,col=k_means$cluster, lwd=10)

## (4) 비계층적 군집분석 - (혁신제품 만족연구)
setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("new_tech.csv", header=TRUE)
t_data2 <- t_data[c(4:8)]
head(t_data2)

wss <- 0
i=1
for(i in 1:5)  #1~5개의 집단 중 하나를 선택하고자 하는 경우
     {
           wss[i] <- sum(kmeans(t_data2,centers=i)$withinss)       
        }
plot(1:5, wss, type="b", xlab="군집 수", ylab="군집 내 제곱합")

k_cluster <- kmeans(t_data2,3)    
k_cluster

k_cluster$cluster

k_group <- k_cluster$cluster
data2 <- cbind(t_data2,k_group)
head(data2)

library(dplyr)
group_sum <- t_data2 %>% group_by(집단=k_group) %>%  summarise(mean(혁신_기술), mean(혁신_디자인)) 
group_sum

plot(t_data2[c("혁신_기술","혁신_디자인")],col=t_data2$k_group)
points(k_cluster$centers[,c("혁신_기술","혁신_디자인")],col=1:3,pch=8,cex=5)


## (5) 연관규칙 1 - (영화시청)
install.packages("arules")
library(arules)
setwd("c:/Data Analysis/r_exam/")
person <- c(1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,8,8,8,9,9,9,10,10,10,10,10)
m_data <-c("아이언맨1","킹덤1","아이언맨2","범죄도시","킹덤2","모가디슈","포켓몬스터","아이언맨2",
                        "아이언맨1","포켓몬스터","식스센스","아이언맨2","킹덤1","모가디슈","킹덤2","식스센스",
                       "킹덤1","킹덤2","미나리","킹덤1","킹덤2","모가디슈","아이언맨1","아이언맨2","범죄도시",
                        "포켓몬스터","미나리","아이언맨1","아이언맨2","모가디슈","범죄도시","킹덤2")
movie <- data.frame(person,m_data)
colnames(movie) <- c("ID","TITLE")
str(movie)

head(movie, 3)
movie$TITLE[movie$ID==1]
movie.list <- split(movie$TITLE, movie$ID)
head(movie.list,3)
movie.watch <- as(movie.list, "transactions")
movie.watch
itemFrequency(x = movie.watch)
image(movie.watch)
summary(movie.watch)
movie.rules1 <- apriori(movie.watch)
summary(movie.rules1)
inspect(movie.rules1) 

movie.rules2 <- apriori(movie.watch, parameter=list(support=0.2, confidence = 0.8,target="rules"))
summary(movie.rules2)
inspect(movie.rules2)

install.packages("arulesViz")
library(arulesViz)
plot(movie.rules2, jitter=1, color=seq(30,100,by=10))
plot(movie.rules2, method="grouped", control=list(k=8)) 
plot(movie.rules2, method="graph", color=seq(50,100,by=10))
plot(movie.rules2, method = "paracoord", control = list(reorder = TRUE))

## (5) 연관규칙 2 - (한국소비자원 소비자 피해구제 정보)
install.packages("arules")
library(arules)
setwd("c:/Data Analysis/r_exam/")
customer<-read.csv("한국소비자원 소비자 피해구제 정보_20210413.csv", header = TRUE, as.is=T)
str(customer)

customer<-read.csv("한국소비자원 소비자 피해구제 정보_20210413.csv", header = TRUE, as.is=F)
str(customer)

tail(customer)

customer_adj <- customer[,-c(1:2,5)]
customer_adj  
head(customer_adj,3)

cu1 <- which(customer_adj$연령대=="불명")
length(cu1)
print(cu1)
cu2 <- which(customer_adj$연령대=="(미입력)")
length(cu2)
print(cu2)
cu3 <- which(customer_adj$청구이유=="")
length(cu3)
print(cu3)

# 미입력된 값 또는 결측치 값 삭제후 남은 데이터를 customer_adj 변수에 저장
customer_adj <- customer_adj[!(customer_adj$연령대=="불명"), ]
customer_adj <- customer_adj[!(customer_adj$연령대=="(미입력)"), ]
customer_adj <- customer_adj[!(customer_adj$청구이유==""), ]

c_data <- as(customer_adj, "transactions")
c_data

# itemFrequency(x = c_data)
# image(c_data) 
summary(c_data)

#판매유형을 기준으로 연관분석 수행 
rules1 <- apriori(customer_adj, parameter = list(minlen=3, support=0.001, confidence= 0.8),
                  appearance = list(rhs=c("판매유형=소셜커머스(쇼핑)", "판매유형=국내온라인거래",
                                                 "판매유형=국제온라인거래","판매유형=TV홈쇼핑")))
inspect(sort(rules1,by="lift"))


#청구이유를 기준으로 연관분석 수행 
rules2<-apriori(customer_adj, parameter = list(minlen=3, support=0.009, confidence= 0.8),
                     appearance = list(rhs=c("청구이유=표시.광고", "청구이유=AS불만",
                              "청구이유=가격.요금","청구이유=계약해제.해지/위약금")))
inspect(sort(rules2,by="lift"))

install.packages("arulesViz")
library(arulesViz)
plot(head(sort(rules1,by="lift"),13), method = "graph")
plot(head(sort(rules1,by="lift"),10), method = "grouped")
plot(head(sort(rules2,by="lift"),15), method = "graph")
plot(head(sort(rules2,by="lift"),10), method = "grouped")

## (6) 연관규칙 3 - ( 2021 한국프로야구 롯데팀 홈런기록)
install.packages("arules")
library(arules)
setwd("c:/Data Analysis/r_exam/")
b_data <- read.csv("20210306_롯데야구기록.csv", header=TRUE, as.is=FALSE)
str(b_data)
tail(b_data)

b_data1 <- as.factor(b_data$월)  #int 타입의 변수를 트랜잭션 처리를 위한 factor 객체로 재처리
b_data2 <- as.factor(b_data$타순) #int 타입의 변수를 트랜잭션 처리를 위한 factor 객체로 재처리
b_data3 <- as.factor(b_data$선수)
b_data4 <- as.factor(b_data$회차) #int 타입의 변수를 트랜잭션 처리를 위한 factor 객체로 재처리
b_data5 <- as.factor(b_data$상대투수)
b_data6 <- as.factor(b_data$홈런)

ball <- data.frame(b_data1,b_data2,b_data3,b_data4,b_data5,b_data6)
colnames(ball) <- c("월","타순","선수","회차","상대투수","홈런")
head(ball)

baseball <- as(ball, "transactions")
print(baseball)
summary(baseball)
baseball@itemInfo[["labels"]]  #91개의 칼럼(item)

rules1<-apriori(baseball, parameter = list(minlen=2, support=0.016, confidence=0.8),
                          appearance=list(lhs=c(paste0("선수=",unique(ball$선수)),
                                             paste0("상대투수=", unique(ball$상대투수))),
                                                        rhs=paste0("홈런=",unique(ball$홈런))))

summary(rules1)
inspect(sort(rules1,by="support"))
inspect(subset(rules1, subset = lhs %pin% c("선수=")))

library(arulesViz)
plot(head(sort(rules1,by="lift"),13), method = "graph", color=seq(50,100,by=10))
plot(head(sort(rules1,by="lift"),110), method = "grouped")


##############################################################
##                     [10장] 텍스트마이닝                  ##
##############################################################

## (1)  stringr() 함수 실습 

install.packages("stringr")
library(stringr)
x <- "josasasa92대한민국100미국90HARUHARUHARU1274유럽92kimmin4쿠jung95"
str_extract(x, "[0-9]{2}")
str_extract(x,"[a-z]{3}") 
str_extract(x,"[가-힣]{2}")

str_extract_all(x, "[0-9]{2}") 
str_extract_all(x,"[가-힣]{2}") 
str_extract_all(x,"[a-z]{3}") 
str_extract_all(x,"[a-z]{8}")

str_extract_all(x,"유럽") 
str_extract_all(x,"남극")

str_extract_all(x,"[a-z]{3,}")
str_extract_all(x,"[가-힣]{3,}")
str_extract_all(x,"[a-z]{6,8}")

str_extract_all(x,"[^a-z]")
str_extract_all(x,"[^가-힣]")
str_extract_all(x,"[^a-z]{4}") 
str_extract_all(x,"[^0-9]{4}")

str_length(x)
str_locate(x, "대한민국")  
str_to_upper(x) 
str_to_lower(x)

str_sub(x, 5,8)
str_sub(x, 1,-40)

x2 <- str_replace(x, "josasasa", "조사사-")   #문자열 변경하기
x2 <- str_replace(x2, "대한민국", "korea-")
x2

x3 <- str_c(x2, "하와이86") #문자열 결합하기
x3

x4 <- str_split(x3, "-")  #문자열 분리하기
x4

## (2) 네이버 영화 크롤링

install.packages("rvest") #rvest는 R의 웹 스크래핑(Web Scraping)을 위한 패키지
install.packages("httr")
library(rvest) 
library(httr)   #서버의 URL을 요청
x <- scan()  #영화 인셉션 52515

url <- paste("https://movie.naver.com/movie/bi/mi/pointWriteFormList.naver?code=",x,sep='')

url_base <- paste(url, "&type=after&isActualPointWriteExecute=false&isMileageSubscriptionAlready=false&isMileageSubscriptionReject=false&page=",sep='')

all.reviews <- c()
k=0

for(page in 1:80){
  
  for(k in 0:9){
    url <- paste(url_base,page,sep='')  
    url <- GET(url)
    #print(url)  
    htxt <- read_html(url)      
    table <- html_nodes(htxt,'.score_result')  
    content <- html_nodes(table, '.score_reple')   
    content2 <- html_elements(content, paste('#_filtered_ment_',k,sep=''))  
    print(paste('#_filtered_ment_',k,sep=''))  
    reviews <- html_text(content2)  
    all.reviews <- c(all.reviews, reviews)  
    k=k+1  
    #print(all.reviews)
  }
  if(length(reviews)==0){break}  
  if(k==10){k=0}  
}
head(all.reviews,3)

all.reviews <- gsub("[\r\n\t]","", all.reviews) #특수기호문자를 공백으로 변경
all.reviews <- gsub("[:cntrl:]","",all.reviews) #제어문자 ASCII CODE (0 ~ 34)를 공백으로 변경
all.reviews <- gsub("[:punct:]","",all.reviews) #특수기호문자를 공백으로 변경
head(all.reviews,3)


install.packages("remotes")   #KoNLP 설치오류시 설치방법
library(remotes) 
remotes::install_github('haven-jeon/KoNLP', upgrade = "never", INSTALL_opts=c("--no-multiarch"),
                          force=TRUE)
library(KoNLP)
useSejongDic()
x <- "설악산풍경은역시가을이최고다"
extractNoun(x)   #extractNoun() 함수는 문장을 단어로 분리한 후 한글 명사를 추출하는 함수

imsi <- "설악산 풍경은 역시 가을이 최고다"
extractNoun(imsi)

useNIADic()
x <- "설악산풍경은역시가을이최고다"
extractNoun(x)   #extractNoun() 함수는 문장을 단어로 분리한 후 한글 명사를 추출하는 함수

imsi <- "설악산 풍경은 역시 가을이 최고다"
extractNoun(imsi)

txt_nouns <- sapply(all.reviews, extractNoun, USE.NAMES = FALSE) #List 객체로 txt_nouns 저장
head(txt_nouns, 3)

noun2 <- unlist(txt_nouns) #단어의 개수를 확인하기 위해 list객체를 해체
library(stringr)
noun2 <- str_replace_all(noun2,"\\^","")
head(noun2,10) 

noun2 <- noun2[nchar(noun2)>=2]  # 한글자로 구성되었는 단어는 삭제후 noun2 변수에 저장
wordcount <- table(noun2)
head(sort(wordcount, decreasing = TRUE),10)

install.packages("wordcloud2")
library(wordcloud2)
wordcloud2(wordcount, shape='circle', size=1.5, fontFamily = '나눔바른고딕')

install.packages("wordcloud")
library(wordcloud)
pal <- brewer.pal(3,"Dark2")
wordcloud(word=names(wordcount), freq=wordcount, min.freq=2, colors=pal, random.color=T)


## (3) 네이버 뉴스 크롤링

install.packages("rvest")
library(rvest) 
library(httr)  
x <- scan(what=character())

url <- paste("https://search.naver.com/search.naver?where=news&sm=tab_pge&query=",x,sep='')
url_base <- paste(url, "&start=",sep='')
all.reviews <- c()

for(page in seq(1, 41, by=10)){
        url <- paste(url_base,page,sep='')   
        url <- GET(url)
        print(url)
        htxt <- read_html(url)  
        table <- html_nodes(htxt,'.group_news') 
        content <- html_nodes(table, '.dsc_wrap')
        reviews <- html_text(content)
       if(length(reviews)==0){break}
        all.reviews <- c(all.reviews, reviews)
     }

head(all.reviews,3)

library(KoNLP)  
useNIADic()   #형태소 사전(1213109개의 단어)
#useSejongDic() #세종 사전(370957개의 단어)

txt_nouns <- sapply(all.reviews, extractNoun, USE.NAMES = FALSE) #List 객체로 txt_nouns 저장
head(txt_nouns, 3)

noun2 <- unlist(txt_nouns) #단어의 개수를 확인하기 위해 list객체를 해체
library(stringr)
noun2 <- str_replace_all(noun2,"[:punct:]","")
head(noun2,10) 

noun2 <- noun2[nchar(noun2)>=2]  # 한글자로 구성되었는 단어는 삭제후 noun2 변수에 저장
wordcount <- table(noun2)
head(sort(wordcount, decreasing = TRUE),10)

install.packages("wordcloud2")
library(wordcloud2)
wordcloud2(wordcount, shape='circle', size=1.5, fontFamily = '나눔바른고딕')

install.packages("wordcloud")
library(wordcloud)
pal <- brewer.pal(3,"Dark2")
wordcloud(word=names(wordcount), freq=wordcount, min.freq=2, colors=pal, random.color=T)


## (4) 음원사이트 댓글 크롤링

install.packages("RSelenium")
install.packages("seleniumPipes")

library(RSelenium)
library(seleniumPipes)
library(rvest)
library(httr)

#cd C:\R_selenium 실행
#java -Dwebdriver.gecko.driver="geckodriver.exe" -jar selenium-server-standalone-4.0.0-alpha-1.jar –port 4445 실행

remDr = remoteDriver(remoteServerAddr="localhost", port=4445, browserName="chrome")
remDr$open()

x <- scan()
url <- paste("https://www.melon.com/album/detail.htm?albumId=",x,sep='')
url_base <- paste(url, "#cmtpgn=&pageNo=",sep='')

all.reviews <- c()
for(page in 1:40){
    url <- paste(url_base,page,sep='')
    remDr$navigate(url)
    txt_page <- remDr$getPageSource()[[1]]
    txt_page <- read_html(txt_page, encoding="UTF-8") 
    reviews <- txt_page %>% html_nodes(".cmt_text") %>% html_text() 
  
    if(length(reviews)==0){break}
    all.reviews <- c(all.reviews, reviews)  
   }

all.reviews <- gsub("[\r\n\t]","", all.reviews) #캐리지 리턴, 줄바꿈, 탭 등의 문자를 공백으로 변경
all.reviews <- gsub("[:cntrl:]","",all.reviews) #제어문자 ASCII CODE를 공백으로 변경
all.reviews <- gsub("[:punct:]","",all.reviews) #특수기호 문자를 공백으로 변경

all.reviews <- iconv(all.reviews, "UTF-8", "CP949", sub="Unicode")
all.reviews <- gsub("[<].*[>]","",all.reviews) #<U+####> 등의 문자를 공백

all.reviews <- gsub("내용","", all.reviews) 
all.reviews <- gsub("재생","",all.reviews)
all.reviews <- gsub("다운로드","",all.reviews) 
all.reviews <- gsub("곡명","",all.reviews)
all.reviews <- gsub("가수","",all.reviews) 
head(all.reviews,3) 

library(KoNLP)  
useNIADic()   #형태소 사전(1213109개의 단어)
txt_nouns <- sapply(all.reviews, extractNoun, USE.NAMES = FALSE) 
head(txt_nouns, 3)

noun2 <- unlist(txt_nouns) 
library(stringr)
#all.reviews 변수에서 제거되지 못한 부분을 다시 한번 stringr 패키지를 이용하여 공백으로 처리
noun2 <- str_replace_all(noun2,"[:punct:]","")  
noun2 <- str_replace_all(noun2,"[:cntrl:]","")
noun2 <- str_replace_all(noun2,"[:digit:]","")  #숫자값을 공백으로 제거
noun2 <- str_replace_all(noun2,"[:lower:]","")
noun2 <- str_replace_all(noun2,"[:upper:]","")
noun2 <- str_replace_all(noun2,"[\r\n\t]","")
noun2 <- str_replace_all(noun2,"\\^","")  #^ 값을 공백으로 제거
noun2 <- str_replace_all(noun2,"가사","") 
noun2 <- str_replace_all(noun2,"내용","")
noun2 <- str_replace_all(noun2,"앨범","")
noun2 <- str_replace_all(noun2,"아티스트명","")
head(noun2,10) 

noun2 <- noun2[nchar(noun2)>=2] 
wordcount <- table(noun2)
head(sort(wordcount, decreasing = TRUE),10)

#install.packages("wordcloud2")
library(wordcloud2)
wordcloud2(wordcount, shape='star', size=8, fontFamily = '나눔바른고딕')

#install.packages("wordcloud")
library(wordcloud)
pal <- brewer.pal(3,"Dark2")
wordcloud(word=names(wordcount), freq=wordcount, min.freq=3, colors=pal, random.color=T)


##############################################################
##                     [11장] 시계열 분석                   ##
##############################################################


## (11-1) 시계열 데이터의 시각화 및 예측 실습 1 - AirPassengers

data(AirPassengers) #12년간 항공기 탑승 승객 수가 있는 시계열 데이터
print(AirPassengers)
str(AirPassengers)

airpass_ts <- window(AirPassengers, start=1949, end=1958.99)
airpass_ts_test <- window(AirPassengers, start=1959)
print(airpass_ts_test)

par(mfrow=c(2,1))
par(mar=c(2, 4, 1, 1))
plot(airpass_ts, ylab="항공여객 (천명)", type="c", pch =20, xaxt='n', xlab="")
text(airpass_ts, col=1:12, labels=1:12, cex=0.7)
plot(airpass_ts, ylab="항공여객 (천명)", type="o", pch =20, xlab="")

#자기상관(auto-correlation) 분석 : acf
par(mfrow=c(1,1))
plot(acf(airpass_ts), main="자기상관(auto-correlation) 분석 : acf")
plot(acf(airpass_ts, type="covariance"), main="자기공분산 분석 : acf")
plot(pacf(airpass_ts), main="부분 자기상관(Partial Auto-Correlation) 분석 : pacf")

#forecast 패키지로 확인
#install.packages("forecast")
library(forecast)
par(mar=c(4, 4, 2, 2))
tsdisplay(airpass_ts,main="국제항공 여객데이터(1949 - 1958)")

#독립성 검정
Box.test(airpass_ts, t="B")
Box.test(airpass_ts, t="L")

#백색잡음 검정
#install.packages("tseries")
library(tseries)
pp.test(airpass_ts)
adf.test(airpass_ts)

#정상성 검정 
kpss.test(airpass_ts, "Level") #시계열자료가 정상성이라는 귀무가설을 기각
kpss.test(airpass_ts, "Trend") #시계열자료가 정상성이라는 귀무가설을 기각

par(mfrow=c(2,2))
par(mar=c(2, 2, 2, 2))
ts.plot(airpass_ts, main="(1) 비정상성(평균변동-분산변동))")
abline(reg=lm(airpass_ts~time(airpass_ts))) 
ap_diff <- diff(airpass_ts) 
ts.plot(ap_diff, main="(2) 비정상성(평균일정-분산변동)") 
ap_log <- log(airpass_ts) 
ts.plot(ap_log, main="(3) 비정상성(평균변동-분산일정)") 
ap_difflog <- diff(log(airpass_ts)) 
ts.plot(ap_difflog, main="(4) 차분과 로그의 계산으로 정상화")

air_add <- decompose(airpass_ts, type="additive") #시계열 데이터의 분해 : 가법모형
plot(air_add)
air_multi <- decompose(airpass_ts, type="multiplicative") #시계열 데이터의 분해 : 승법모형
plot(air_multi)

par(mfrow=c(2,2))
par(mar=c(2, 2, 2, 2))
plot(airpass_ts-air_add$seasonal, main="계절변동을 제거한 시계열 자료:가법모형")
plot(airpass_ts/air_multi$seasonal,main="계절변동을 제거한 시계열 자료:승법모형")
plot(airpass_ts-air_add$trend, main="추세변동을 제거한 시계열 자료:가법모형")
plot(airpass_ts/air_multi$trend, main="추세변동을 제거한 시계열 자료:승법모형")

#시계열 데이터의 분해 : 가법모형과 승법모형의 정상성 검정
library(tseries)
kpss.test(air_add$random)
kpss.test(air_multi$random)
kpss.test(air_add$random, "Trend")
kpss.test(air_multi$random, "Trend")
tsdisplay(air_add$random)
tsdisplay(air_multi$random)

#시계열 분석모형
air_ts_models <- list (
  ARIMA_Model = auto.arima(airpass_ts, ic='aicc', stepwise=FALSE),
  ETS_Model = ets(airpass_ts, ic='aicc', restrict=FALSE, model = "ZZZ"),
  Neural_Model = nnetar(airpass_ts, p=12, size=12),
  TBATS_Model = tbats(airpass_ts, ic='aicc', seasonal.periods=12),
  BATS_Model = bats(airpass_ts, ic='aicc', seasonal.periods=12),
  STL_Model = stlm(airpass_ts, s.window=12, ic='aicc', robust=TRUE, method='ets'),
  StructTS_Model = StructTS(airpass_ts)
)

air_forecasts <- lapply(air_ts_models, forecast, 24)
air_forecasts$Naive_Model <- naive(airpass_ts, 24) 
print(air_forecasts)

TBATS_Model_residuals <- air_ts_models$TBATS_Model$y - air_ts_models$TBATS_Model$fitted.values
BATS_Model_residuals <- air_ts_models$BATS_Model$y - air_ts_models$BATS_Model$fitted.values

library(forecast)
Box.test(air_ts_models$ARIMA_Model$residuals, t="L")
Box.test(air_ts_models$ETS_Model$residuals, t="L")
Box.test(air_ts_models$Neural_Model$residuals, t="L")
Box.test(TBATS_Model_residuals, t="L")
Box.test(BATS_Model_residuals, t="L")
Box.test(air_ts_models$STL_Model$residuals, t="L")
Box.test(air_ts_models$StructTS_Model$residuals, t="L")
Box.test(air_forecasts$Naive_Model$residuals, t="L")

kpss.test(air_ts_models$ARIMA_Model$residuals)
kpss.test(air_ts_models$ARIMA_Model$residuals , "Trend")
kpss.test(air_ts_models$ETS_Model$residuals)
kpss.test(air_ts_models$ETS_Model$residuals , "Trend")
kpss.test(c(air_ts_models$Neural_Model$residuals[-c(1:12)]))
kpss.test(c(air_ts_models$Neural_Model$residuals[-c(1:12)]) , "Trend")
kpss.test(TBATS_Model_residuals)
kpss.test(TBATS_Model_residuals , "Trend")
kpss.test(BATS_Model_residuals)
kpss.test(BATS_Model_residuals , "Trend")
kpss.test(air_ts_models$STL_Model$residuals)
kpss.test(air_ts_models$STL_Model$residuals , "Trend")
kpss.test(air_ts_models$StructTS_Model$residuals)
kpss.test(air_ts_models$StructTS_Model$residuals , "Trend")
kpss.test(c(air_forecasts$Naive_Model$residuals[-1]))
kpss.test(c(air_forecasts$Naive_Model$residuals[-1]) , "Trend")

adf.test(air_ts_models$ARIMA_Model$residuals)
adf.test(air_ts_models$ETS_Model$residuals)
adf.test(c(air_ts_models$Neural_Model$residuals[-c(1:12)]))
adf.test(TBATS_Model_residuals)
adf.test(BATS_Model_residuals)
adf.test(air_ts_models$STL_Model$residuals)
adf.test(air_ts_models$StructTS_Model$residuals)
adf.test(c(air_forecasts$Naive_Model$residuals[-1]))

par(mfrow=c(4, 2))
par(mar=c(2, 2, 1.5, 2), xaxs='i', yaxs='i')

k=1
for(t in air_forecasts){
  plot(t, ylim=c(0,600), main=names(air_forecasts[k]), xaxt="n")
  lines(airpass_ts_test, col='red')
  k=k+1
}

model_est <- lapply(air_forecasts, function(t){
  accuracy(t, airpass_ts_test)[2,,drop=F]
})

model_est <- Reduce(rbind, model_est)
row.names(model_est) <- names(air_forecasts)
model_est <- model_est[order(model_est[,8]),]
round(model_est, 2)

dm.test(model_est[1,], model_est[2,], alternative = "two.sided")

# 최적의 모형결정 
aa_air <- tbats(airpass_ts, ic='aicc', seasonal.periods=12)
forecast(aa_air, h=48)
par(mfrow = c(1,1))
plot(forecast(aa_air))
lines(airpass_ts_test, col='red')


## (11-2) 시계열 데이터의 시각화 및 예측 실습 2 - 대구도시철도공사_월별승차인원

#https://www.data.go.kr/data/15060371/fileData.do
setwd("C:/Data Analysis/r_exam")
daegu_data <- read.csv("대구도시철도공사_월별승차인원_20210731.csv", header=T)
str(daegu_data)

daegu_data1 <- daegu_data[,6] #1997~2021년까지의 대구지하철의 진천역 월별승차인원
daegu_subway_data <- ts(daegu_data1, start=c(1997,11), frequency = 12)

dsubway_ts <- window(daegu_subway_data, end=2018.99)
dsubway_ts_test <- window(daegu_subway_data, start=2019)
print(dsubway_ts_test)

par(mfrow=c(2,1))
par(mar=c(2, 4, 1, 1))
plot(dsubway_ts, ylab="월별승차인원(명)", type="c", pch =20)
text(dsubway_ts, col=1:12, labels=1:12, cex=0.7)
plot(dsubway_ts, ylab="월별승차인원(명)", type="o", pch =20)

#forecast 패키지로 확인
#install.packages("forecast")
library(forecast)
par(mar=c(4, 4, 2, 2))
tsdisplay(dsubway_ts,main="대구지하철 월별승차인원(1997 - 2017)")

#독립성 검정
Box.test(dsubway_ts, t="L")

#정상성 검정 
library(tseries)
kpss.test(dsubway_ts, "Level") 
kpss.test(dsubway_ts, "Trend") 


#백색잡음 검정
#install.packages("tseries")
library(tseries)
pp.test(dsubway_ts)
adf.test(dsubway_ts)

dsubway_add <- decompose(dsubway_ts, type="additive") #시계열 데이터의 분해 : 가법모형
plot(dsubway_add)
dsubway_multi <- decompose(dsubway_ts, type="multiplicative") #시계열 데이터의 분해 : 승법모형
plot(dsubway_multi)

par(mfrow=c(2,2))
par(mar=c(2, 2, 2, 2))
plot(dsubway_ts-dsubway_add$seasonal, main="계절변동을 제거한 시계열 자료:가법모형")
plot(dsubway_ts/dsubway_multi$seasonal,main="계절변동을 제거한 시계열 자료:승법모형")
plot(dsubway_ts-dsubway_add$trend, main="추세변동을 제거한 시계열 자료:가법모형")
plot(dsubway_ts/dsubway_multi$trend, main="추세변동을 제거한 시계열 자료:승법모형")

#시계열 데이터의 분해 : 가법모형과 승법모형의 정상성 검정
library(tseries)
kpss.test(dsubway_add$random)
kpss.test(dsubway_multi$random)
kpss.test(dsubway_add$random, "Trend")
kpss.test(dsubway_multi$random, "Trend")
tsdisplay(dsubway_add$random)
tsdisplay(dsubway_multi$random)

#시계열 분석모형
dsubway_ts_models <- list (
  ARIMA_Model = auto.arima(dsubway_ts, ic='aicc', stepwise=FALSE),
  ETS_Model = ets(dsubway_ts, ic='aicc', restrict=FALSE, model = "ZZZ"),
  Neural_Model = nnetar(dsubway_ts, p=12, size=6),
  TBATS_Model = tbats(dsubway_ts, ic='aicc', seasonal.periods=12),
  BATS_Model = bats(dsubway_ts, ic='aicc', seasonal.periods=12),
  STL_Model = stlm(dsubway_ts, s.window=12, ic='aicc', robust=TRUE, method='ets'),
  StructTS_Model = StructTS(dsubway_ts)
)

dsubway_forecasts <- lapply(dsubway_ts_models, forecast, 36)
dsubway_forecasts$Naive_Model <- naive(dsubway_ts, 36) 
print(dsubway_forecasts)

TBATS_Model_residuals <- dsubway_ts_models$TBATS_Model$y - dsubway_ts_models$TBATS_Model$fitted.values
BATS_Model_residuals <- dsubway_ts_models$BATS_Model$y - dsubway_ts_models$BATS_Model$fitted.values

library(forecast)
Box.test(dsubway_ts_models$ARIMA_Model$residuals, t="L")
Box.test(dsubway_ts_models$ETS_Model$residuals, t="L")
Box.test(dsubway_ts_models$Neural_Model$residuals, t="L") 
Box.test(TBATS_Model_residuals, t="L")  
Box.test(BATS_Model_residuals, t="L")
Box.test(dsubway_ts_models$STL_Model$residuals, t="L")
Box.test(dsubway_ts_models$StructTS_Model$residuals, t="L")  
Box.test(dsubway_forecasts$Naive_Model$residuals, t="L")  

kpss.test(dsubway_ts_models$ARIMA_Model$residuals)
kpss.test(dsubway_ts_models$ARIMA_Model$residuals , "Trend") 
kpss.test(dsubway_ts_models$ETS_Model$residuals)
kpss.test(dsubway_ts_models$ETS_Model$residuals , "Trend")
kpss.test(c(dsubway_ts_models$Neural_Model$residuals[-c(1:12)]))
kpss.test(c(dsubway_ts_models$Neural_Model$residuals[-c(1:12)]) , "Trend")
kpss.test(TBATS_Model_residuals)
kpss.test(TBATS_Model_residuals , "Trend")
kpss.test(BATS_Model_residuals)
kpss.test(BATS_Model_residuals , "Trend")
kpss.test(dsubway_ts_models$STL_Model$residuals)
kpss.test(dsubway_ts_models$STL_Model$residuals , "Trend")
kpss.test(dsubway_ts_models$StructTS_Model$residuals)
kpss.test(dsubway_ts_models$StructTS_Model$residuals , "Trend")
kpss.test(c(dsubway_forecasts$Naive_Model$residuals[-1]))
kpss.test(c(dsubway_forecasts$Naive_Model$residuals[-1]) , "Trend")  ##

adf.test(dsubway_ts_models$ARIMA_Model$residuals)
adf.test(dsubway_ts_models$ETS_Model$residuals)
adf.test(c(dsubway_ts_models$Neural_Model$residuals[-c(1:12)]))
adf.test(TBATS_Model_residuals)
adf.test(BATS_Model_residuals)
adf.test(dsubway_ts_models$STL_Model$residuals)
adf.test(dsubway_ts_models$StructTS_Model$residuals) 
adf.test(c(dsubway_forecasts$Naive_Model$residuals[-1])) 

pp.test(dsubway_ts_models$ARIMA_Model$residuals)
pp.test(dsubway_ts_models$ETS_Model$residuals)
pp.test(c(dsubway_ts_models$Neural_Model$residuals[-c(1:12)]))
pp.test(TBATS_Model_residuals)
pp.test(BATS_Model_residuals)
pp.test(dsubway_ts_models$STL_Model$residuals)
pp.test(dsubway_ts_models$StructTS_Model$residuals) 
pp.test(c(dsubway_forecasts$Naive_Model$residuals[-1])) 

par(mfrow=c(4, 2))
par(mar=c(2, 2, 3, 2))

k=1
for(t in dsubway_forecasts){
  plot(t, ylim=c(50000,300000), main=names(dsubway_forecasts[k]))
  lines(dsubway_ts_test, col='red')
  k=k+1
}

model_est <- lapply(dsubway_forecasts, function(t){
  accuracy(t, dsubway_ts_test)[2,,drop=F]
})

model_est <- Reduce(rbind, model_est)
row.names(model_est) <- names(dsubway_forecasts)
model_est <- model_est[order(model_est[,8]),]
round(model_est, 2)

dm.test(model_est[1,], model_est[2,], alternative = "two.sided")

# 최적의 모형결정 
aa_dsubway <- stlm(dsubway_ts, s.window=12, ic='aicc', robust=TRUE, method='ets')
forecast(aa_dsubway, h=48)
par(mfrow = c(1,1))
plot(forecast(aa_dsubway))
lines(dsubway_ts_test, col='red')


## (11-3) 시계열 데이터의 시각화 및 예측 실습 3 -  사고유형별/월별 교통사고 데이터

setwd("C:/Data Analysis/r_exam")
t_data <- read.csv("도로교통공단_사고유형별 월별 교통사고(2014~2019).csv", header=T)
head(t_data)

t_data1 <- t_data[1:72,6] #2014~2019년까지의 차대사람(횡단중) 교통사고
cross <- ts(t_data1, start=c(2014,1), frequency = 12)
print(cross)
cross_ts <- window(cross, end=2018.99)
cross_ts_test <- window(cross, start=2019)
print(cross_ts_test)

par(mfrow=c(2,1))
par(mar=c(2, 4, 1, 1))
plot(cross_ts, ylab="차대사람 - 횡단중 사고건수", type="c", pch =20)
text(cross_ts, col=1:12, labels=1:12, cex=0.7)
plot(cross_ts, ylab="차대사람 - 횡단중 사고건수", type="o", pch =20)


#forecast 패키지로 확인
#install.packages("forecast")
library(forecast)
par(mar=c(4, 4, 2, 2))
tsdisplay(cross_ts,main="차대사람 - 횡단중 사고건수(2014 - 2018)")

#독립성 검정
Box.test(cross_ts, t="L")

#정상성 검정 
kpss.test(cross_ts, "Level") 
kpss.test(cross_ts, "Trend") 


#백색잡음 검정
#install.packages("tseries")
library(tseries)
pp.test(cross_ts)
adf.test(cross_ts)

cross_add <- decompose(cross_ts, type="additive") #시계열 데이터의 분해 : 가법모형
plot(cross_add)
cross_multi <- decompose(cross_ts, type="multiplicative") #시계열 데이터의 분해 : 승법모형
plot(cross_multi)

par(mfrow=c(2,2))
par(mar=c(2, 2, 2, 2))
plot(cross_ts-cross_add$seasonal, main="계절변동을 제거한 시계열 자료:가법모형")
plot(cross_ts/cross_multi$seasonal,main="계절변동을 제거한 시계열 자료:승법모형")
plot(cross_ts-cross_add$trend, main="추세변동을 제거한 시계열 자료:가법모형")
plot(cross_ts/cross_multi$trend, main="추세변동을 제거한 시계열 자료:승법모형")

#시계열 데이터의 분해 : 가법모형과 승법모형의 정상성 검정
library(tseries)
kpss.test(cross_add$random)
kpss.test(cross_multi$random)
kpss.test(cross_add$random, "Trend")
kpss.test(cross_multi$random, "Trend")
tsdisplay(cross_add$random)
tsdisplay(cross_multi$random)

#시계열 분석모형
cross_ts_models <- list (
  ARIMA_Model = auto.arima(cross_ts, ic='aicc', stepwise=FALSE),
  ETS_Model = ets(cross_ts, ic='aicc', restrict=FALSE, model = "ZZZ"),
  Neural_Model = nnetar(cross_ts, p=12, size=6),
  TBATS_Model = tbats(cross_ts, ic='aicc', seasonal.periods=12),
  BATS_Model = bats(cross_ts, ic='aicc', seasonal.periods=12),
  STL_Model = stlm(cross_ts, s.window=12, ic='aicc', robust=TRUE, method='ets'),
  StructTS_Model = StructTS(cross_ts)
)

cross_forecasts <- lapply(cross_ts_models, forecast, 24)
cross_forecasts$Naive_Model <- naive(cross_ts, 24) 
print(cross_forecasts)

TBATS_Model_residuals <- cross_ts_models$TBATS_Model$y - cross_ts_models$TBATS_Model$fitted.values
BATS_Model_residuals <- cross_ts_models$BATS_Model$y - cross_ts_models$BATS_Model$fitted.values

library(forecast)
Box.test(cross_ts_models$ARIMA_Model$residuals, t="L")
Box.test(cross_ts_models$ETS_Model$residuals, t="L")
Box.test(cross_ts_models$Neural_Model$residuals, t="L") 
Box.test(TBATS_Model_residuals, t="L")  
Box.test(BATS_Model_residuals, t="L")
Box.test(cross_ts_models$STL_Model$residuals, t="L")
Box.test(cross_ts_models$StructTS_Model$residuals, t="L")  
Box.test(cross_forecasts$Naive_Model$residuals, t="L")  


kpss.test(cross_ts_models$ARIMA_Model$residuals)
kpss.test(cross_ts_models$ARIMA_Model$residuals , "Trend") 
kpss.test(cross_ts_models$ETS_Model$residuals)
kpss.test(cross_ts_models$ETS_Model$residuals , "Trend")
kpss.test(c(cross_ts_models$Neural_Model$residuals[-c(1:12)]))
kpss.test(c(cross_ts_models$Neural_Model$residuals[-c(1:12)]) , "Trend")
kpss.test(TBATS_Model_residuals)
kpss.test(TBATS_Model_residuals , "Trend")
kpss.test(BATS_Model_residuals)
kpss.test(BATS_Model_residuals , "Trend")
kpss.test(cross_ts_models$STL_Model$residuals)
kpss.test(cross_ts_models$STL_Model$residuals , "Trend")
kpss.test(cross_ts_models$StructTS_Model$residuals)
kpss.test(cross_ts_models$StructTS_Model$residuals , "Trend")
kpss.test(c(cross_forecasts$Naive_Model$residuals[-1]))
kpss.test(c(cross_forecasts$Naive_Model$residuals[-1]) , "Trend")


adf.test(cross_ts_models$ARIMA_Model$residuals)
adf.test(cross_ts_models$ETS_Model$residuals)
adf.test(c(cross_ts_models$Neural_Model$residuals[-c(1:12)]))
adf.test(TBATS_Model_residuals)
adf.test(BATS_Model_residuals)
adf.test(cross_ts_models$STL_Model$residuals)
adf.test(cross_ts_models$StructTS_Model$residuals) 
adf.test(c(cross_forecasts$Naive_Model$residuals[-1])) 


par(mfrow=c(4, 2))
par(mar=c(2, 2, 3, 2))

k=1
for(t in cross_forecasts){
  plot(t, ylim=c(-100,4000), main=names(cross_forecasts[k]))
  lines(cross_ts_test, col='red')
  k=k+1
}

model_est <- lapply(cross_forecasts, function(t){
  accuracy(t, cross_ts_test)[2,,drop=F]
})

model_est <- Reduce(rbind, model_est)
row.names(model_est) <- names(cross_forecasts)
model_est <- model_est[order(model_est[,8]),]
round(model_est, 2)

dm.test(model_est[1,], model_est[2,], alternative = "two.sided")

## 최적의 모형결정 
aa_cross <- stlm(cross_ts, s.window=12, ic='aicc', robust=TRUE, method='ets')
forecast(aa_cross, h=48)
par(mfrow = c(1,1))
plot(forecast(aa_cross))
lines(cross_ts_test, col='red')


